/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import java.util.Set;

public class CodegenField {
    private final String clazz;
    private final String name;
    private final EPTypeClass type;
    private final boolean isFinal;
    private String assignmentMemberName;

    public CodegenField(String clazz, String name, EPTypeClass type, boolean isFinal) {
        this.clazz = clazz;
        this.name = name;
        this.type = type;
        this.isFinal = isFinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenField that = (CodegenField)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void mergeClasses(Set<Class> classes) {
        this.type.traverseClasses(classes::add);
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public EPTypeClass getType() {
        return this.type;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void render(StringBuilder builder) {
        builder.append(this.clazz).append('.');
        if (this.assignmentMemberName != null) {
            builder.append(this.assignmentMemberName).append(".");
        }
        builder.append(this.name);
    }

    public void setAssignmentMemberName(String assignmentMemberName) {
        this.assignmentMemberName = assignmentMemberName;
    }

    public CodegenExpressionRef getNameWithMember() {
        if (this.assignmentMemberName == null) {
            return CodegenExpressionBuilder.ref(this.name);
        }
        return CodegenExpressionBuilder.ref(this.assignmentMemberName + "." + this.name);
    }
}

