/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMemberWCol;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CodegenMemberCol {
    private final LinkedHashMap<CodegenExpressionMemberWCol, EPTypeClass> members = new LinkedHashMap();

    public CodegenExpressionMember addMember(int column, EPTypeClass type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        CodegenExpressionMemberWCol ref = new CodegenExpressionMemberWCol(name, column);
        this.members.put(ref, type);
        return ref;
    }

    public void put(CodegenExpressionMemberWCol member, EPTypeClass type) {
        this.members.put(member, type);
    }

    public LinkedHashMap<CodegenExpressionMemberWCol, EPTypeClass> getMembers() {
        return this.members;
    }

    public TreeMap<Integer, List<CodegenExpressionMemberWCol>> getMembersPerColumn() {
        TreeMap<Integer, List<CodegenExpressionMemberWCol>> columns = new TreeMap<Integer, List<CodegenExpressionMemberWCol>>();
        for (Map.Entry<CodegenExpressionMemberWCol, EPTypeClass> entry : this.members.entrySet()) {
            int col = entry.getKey().getCol();
            List members = columns.computeIfAbsent(col, k -> new ArrayList(2));
            members.add(entry.getKey());
        }
        return columns;
    }

    public EPTypeClass get(CodegenExpressionMemberWCol member) {
        return this.members.get(member);
    }
}

