/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import java.util.Map;
import java.util.Set;

public class CodegenClassReference {
    private final EPTypeClass clazz;
    private final String className;

    public CodegenClassReference(String className) {
        this.clazz = null;
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.className = className;
    }

    public CodegenClassReference(EPTypeClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
        this.className = null;
    }

    public EPTypeClass getClazz() {
        return this.clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public void addReferenced(Set<Class> classes) {
        if (this.clazz != null) {
            this.clazz.traverseClasses(classes::add);
        }
    }

    public void render(StringBuilder builder, Map<Class, String> imports) {
        if (this.clazz != null) {
            CodeGenerationHelper.appendClassName(builder, this.clazz, imports);
        } else {
            builder.append(this.className);
        }
    }
}

