/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CodegenNamedMethods {
    private Map<String, CodegenMethod> methods;

    public CodegenMethod addMethod(EPTypeClass returnType, String methodName, List<CodegenNamedParam> params, Class generator, CodegenClassScope classScope, Consumer<CodegenMethod> code) {
        return this.addMethodWithSymbols(returnType, methodName, params, generator, classScope, code, CodegenSymbolProviderEmpty.INSTANCE);
    }

    public CodegenMethod addMethodWithSymbols(EPTypeClass returnType, String methodName, List<CodegenNamedParam> params, Class generator, CodegenClassScope classScope, Consumer<CodegenMethod> code, CodegenSymbolProvider symbolProvider) {
        CodegenMethod existing;
        if (this.methods == null) {
            this.methods = new HashMap<String, CodegenMethod>();
        }
        if ((existing = this.methods.get(methodName)) != null) {
            if (params.equals(existing.getLocalParams())) {
                return existing;
            }
            throw new IllegalStateException("Method by name '" + methodName + "' already registered");
        }
        CodegenMethod method = CodegenMethod.makeParentNode(returnType, generator, symbolProvider, (CodegenScope)classScope).addParam(params);
        this.methods.put(methodName, method);
        code.accept(method);
        return method;
    }

    public Map<String, CodegenMethod> getMethods() {
        return this.methods == null ? Collections.emptyMap() : this.methods;
    }

    public CodegenMethod getMethod(String name) {
        CodegenMethod method = this.methods.get(name);
        if (method == null) {
            throw new IllegalStateException("Method by name '" + method + "' not found");
        }
        return method;
    }
}

