/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenChainElement {
    private final String method;
    private final CodegenExpression[] optionalParams;

    public CodegenChainElement(String method, CodegenExpression[] optionalParams) {
        this.method = method;
        this.optionalParams = optionalParams;
        if (optionalParams != null) {
            for (int i = 0; i < optionalParams.length; ++i) {
                if (optionalParams[i] != null) continue;
                throw new IllegalArgumentException("Invalid null expression parameter at position " + i);
            }
        }
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append(this.method).append("(");
        if (this.optionalParams != null) {
            String delimiter = "";
            for (CodegenExpression param : this.optionalParams) {
                builder.append(delimiter);
                param.render(builder, imports, isInnerClass);
                delimiter = ",";
            }
        }
        builder.append(")");
    }

    public void mergeClasses(Set<Class> classes) {
        if (this.optionalParams != null) {
            for (CodegenExpression param : this.optionalParams) {
                param.mergeClasses(classes);
            }
        }
    }

    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        CodegenExpressionBuilder.traverseMultiple(this.optionalParams, consumer);
    }
}

