/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Map;

public class CodegenExpressionEPType {
    public static CodegenExpression toExpression(EPType epType) {
        if (epType instanceof EPTypeNull) {
            return CodegenExpressionBuilder.enumValue(EPTypeNull.class, "INSTANCE");
        }
        EPTypeClass epTypeClass = (EPTypeClass)epType;
        if (!(epType instanceof EPTypeClassParameterized)) {
            EPTypePremade existing = EPTypePremade.getExisting(epTypeClass.getType());
            if (existing != null) {
                return CodegenExpressionBuilder.enumValue(EPTypePremade.class, existing.name() + ".getEPType()");
            }
            return CodegenExpressionBuilder.newInstance(EPTypeClass.EPTYPE, CodegenExpressionBuilder.constant(epTypeClass.getType()));
        }
        EPTypeClassParameterized parameterized = (EPTypeClassParameterized)epType;
        EPTypeClass[] parameters = parameterized.getParameters();
        CodegenExpression[] params = new CodegenExpression[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = CodegenExpressionEPType.toExpression(parameters[i]);
        }
        return CodegenExpressionBuilder.newInstance(EPTypeClassParameterized.EPTYPE, CodegenExpressionBuilder.constant(epTypeClass.getType()), CodegenExpressionBuilder.newArrayWithInit(EPTypeClass.EPTYPE, params));
    }

    public static void render(EPType constant, StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        CodegenExpression expression = CodegenExpressionEPType.toExpression(constant);
        expression.render(builder, imports, isInnerClass);
    }
}

