/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementDeclareVar
extends CodegenStatementBase {
    private final EPTypeClass clazz;
    private final String typeName;
    private final String var;
    private final CodegenExpression optionalInitializer;

    public CodegenStatementDeclareVar(EPTypeClass clazz, String var, CodegenExpression optionalInitializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        this.clazz = clazz;
        this.typeName = null;
        this.var = var;
        this.optionalInitializer = optionalInitializer;
    }

    public CodegenStatementDeclareVar(String typeName, String var, CodegenExpression optionalInitializer) {
        if (typeName == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        this.clazz = null;
        this.typeName = typeName;
        this.var = var;
        this.optionalInitializer = optionalInitializer;
    }

    @Override
    public void renderStatement(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.clazz != null) {
            CodeGenerationHelper.appendClassName(builder, this.clazz, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.typeName);
        }
        builder.append(" ").append(this.var);
        if (this.optionalInitializer != null) {
            builder.append("=");
            this.optionalInitializer.render(builder, imports, isInnerClass);
        }
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        if (this.clazz != null) {
            this.clazz.traverseClasses(classes::add);
        }
        if (this.optionalInitializer != null) {
            this.optionalInitializer.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        if (this.optionalInitializer != null) {
            consumer.accept(this.optionalInitializer);
        }
    }
}

