/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementFor
extends CodegenStatementWBlockBase {
    private final EPTypeClass type;
    private final String name;
    private final CodegenExpression initialization;
    private final CodegenExpression termination;
    private final CodegenExpression increment;
    private CodegenBlock block;

    public CodegenStatementFor(CodegenBlock parent, EPTypeClass type, String name, CodegenExpression initialization, CodegenExpression termination, CodegenExpression increment) {
        super(parent);
        this.type = type;
        this.name = name;
        this.initialization = initialization;
        this.termination = termination;
        this.increment = increment;
    }

    public void setBlock(CodegenBlock block) {
        this.block = block;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("for (");
        CodeGenerationHelper.appendClassName(builder, this.type, imports);
        builder.append(" ").append(this.name).append("=");
        this.initialization.render(builder, imports, isInnerClass);
        builder.append("; ");
        this.termination.render(builder, imports, isInnerClass);
        builder.append("; ");
        this.increment.render(builder, imports, isInnerClass);
        builder.append(") {\n");
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.block.mergeClasses(classes);
        this.initialization.mergeClasses(classes);
        this.termination.mergeClasses(classes);
        this.increment.mergeClasses(classes);
        this.type.traverseClasses(classes::add);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        this.block.traverseExpressions(consumer);
        consumer.accept(this.initialization);
        consumer.accept(this.termination);
        consumer.accept(this.increment);
    }
}

