/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementForEach
extends CodegenStatementWBlockBase {
    private final EPTypeClass type;
    private final String ref;
    private final CodegenExpression target;
    private CodegenBlock block;

    public CodegenStatementForEach(CodegenBlock parent, EPTypeClass type, String ref, CodegenExpression target) {
        super(parent);
        this.type = type;
        this.ref = ref;
        this.target = target;
    }

    public void setBlock(CodegenBlock block) {
        this.block = block;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("for (");
        CodeGenerationHelper.appendClassName(builder, this.type, imports);
        builder.append(" ").append(this.ref).append(" : ");
        this.target.render(builder, imports, isInnerClass);
        builder.append(") {\n");
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.type.traverseClasses(classes::add);
        this.block.mergeClasses(classes);
        this.target.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.target);
        this.block.traverseExpressions(consumer);
    }
}

