/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementForIntSimple
extends CodegenStatementWBlockBase {
    private final String ref;
    private final CodegenExpression upperLimit;
    private CodegenBlock block;

    public CodegenStatementForIntSimple(CodegenBlock parent, String ref, CodegenExpression upperLimit) {
        super(parent);
        this.ref = ref;
        this.upperLimit = upperLimit;
    }

    public void setBlock(CodegenBlock block) {
        this.block = block;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("for (int ").append(this.ref).append("=0; ").append(this.ref).append("<");
        this.upperLimit.render(builder, imports, isInnerClass);
        builder.append("; ").append(this.ref).append("++) {\n");
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.block.mergeClasses(classes);
        this.upperLimit.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.upperLimit);
        this.block.traverseExpressions(consumer);
    }
}

