/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementIfConditionBlock {
    private final CodegenExpression condition;
    private final CodegenBlock block;

    public CodegenStatementIfConditionBlock(CodegenExpression condition, CodegenBlock block) {
        this.condition = condition;
        this.block = block;
    }

    public CodegenExpression getCondition() {
        return this.condition;
    }

    public CodegenBlock getBlock() {
        return this.block;
    }

    public void mergeClasses(Set<Class> classes) {
        this.condition.mergeClasses(classes);
        this.block.mergeClasses(classes);
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("if (");
        this.condition.render(builder, imports, isInnerClass);
        builder.append(") {\n");
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}");
    }

    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.condition);
        this.block.traverseExpressions(consumer);
    }
}

