/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementSwitch
extends CodegenStatementWBlockBase {
    private final CodegenExpression switchExpression;
    private final CodegenExpression[] options;
    private final CodegenBlock[] blocks;
    private final CodegenBlock defaultBlock;
    private final boolean blocksReturnValues;
    private final boolean withDefaultUnsupported;

    public CodegenStatementSwitch(CodegenBlock parent, CodegenExpression switchExpression, CodegenExpression[] options, boolean blocksReturnValues, boolean withDefaultUnsupported) {
        super(parent);
        this.switchExpression = switchExpression;
        this.options = options;
        this.blocks = new CodegenBlock[options.length];
        for (int i = 0; i < options.length; ++i) {
            this.blocks[i] = new CodegenBlock(this);
        }
        this.blocksReturnValues = blocksReturnValues;
        this.withDefaultUnsupported = withDefaultUnsupported;
        this.defaultBlock = new CodegenBlock(this);
    }

    public CodegenBlock[] getBlocks() {
        return this.blocks;
    }

    public CodegenBlock getDefaultBlock() {
        return this.defaultBlock;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("switch(");
        this.switchExpression.render(builder, imports, isInnerClass);
        builder.append(") {\n");
        for (int i = 0; i < this.options.length; ++i) {
            indent.indent(builder, level + 1);
            builder.append("case ");
            this.options[i].render(builder, imports, isInnerClass);
            builder.append(": {\n");
            this.blocks[i].render(builder, imports, isInnerClass, level + 2, indent);
            if (!this.blocksReturnValues) {
                indent.indent(builder, level + 2);
                builder.append("break;\n");
            }
            indent.indent(builder, level + 1);
            builder.append("}\n");
        }
        builder.append("default: ");
        if (this.withDefaultUnsupported) {
            indent.indent(builder, level + 1);
            builder.append("throw new UnsupportedOperationException();\n");
        } else {
            this.defaultBlock.render(builder, imports, isInnerClass, level + 2, indent);
        }
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        int i;
        this.switchExpression.mergeClasses(classes);
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].mergeClasses(classes);
        }
        for (i = 0; i < this.options.length; ++i) {
            this.options[i].mergeClasses(classes);
        }
        if (this.defaultBlock != null) {
            this.defaultBlock.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        int i;
        consumer.accept(this.switchExpression);
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].traverseExpressions(consumer);
        }
        for (i = 0; i < this.options.length; ++i) {
            consumer.accept(this.options[i]);
        }
        if (this.defaultBlock != null) {
            this.defaultBlock.traverseExpressions(consumer);
        }
    }
}

