/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementTryCatchCatchBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementTryCatch
extends CodegenStatementWBlockBase {
    private CodegenBlock tryBlock;
    private List<CodegenStatementTryCatchCatchBlock> catchBlocks = new ArrayList<CodegenStatementTryCatchCatchBlock>(1);
    private CodegenBlock finallyBlock;

    public CodegenStatementTryCatch(CodegenBlock parent) {
        super(parent);
    }

    public void setTry(CodegenBlock block) {
        if (this.tryBlock != null) {
            throw new IllegalStateException("Try-block already provided");
        }
        this.tryBlock = block;
    }

    public CodegenBlock addCatch(EPTypeClass ex, String name) {
        CodegenBlock block = new CodegenBlock(this);
        this.catchBlocks.add(new CodegenStatementTryCatchCatchBlock(ex, name, block));
        return block;
    }

    public CodegenBlock tryFinally() {
        if (this.finallyBlock != null) {
            throw new IllegalStateException("Finally already set");
        }
        this.finallyBlock = new CodegenBlock(this);
        return this.finallyBlock;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("try {\n");
        this.tryBlock.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}");
        String delimiter = "";
        for (CodegenStatementTryCatchCatchBlock pair : this.catchBlocks) {
            builder.append(delimiter);
            builder.append(" catch (");
            CodeGenerationHelper.appendClassName(builder, pair.getEx(), imports);
            builder.append(' ');
            builder.append(pair.getName());
            builder.append(") {\n");
            pair.getBlock().render(builder, imports, isInnerClass, level + 1, indent);
            indent.indent(builder, level);
            builder.append("}");
            delimiter = "\n";
        }
        if (this.finallyBlock != null) {
            builder.append("\n");
            indent.indent(builder, level);
            builder.append("finally {\n");
            this.finallyBlock.render(builder, imports, isInnerClass, level + 1, indent);
            indent.indent(builder, level);
            builder.append("}");
        }
        builder.append("\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.tryBlock.mergeClasses(classes);
        for (CodegenStatementTryCatchCatchBlock pair : this.catchBlocks) {
            pair.mergeClasses(classes);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        this.tryBlock.traverseExpressions(consumer);
        for (CodegenStatementTryCatchCatchBlock pair : this.catchBlocks) {
            pair.traverseExpressions(consumer);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.traverseExpressions(consumer);
        }
    }
}

