/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collections;
import java.util.Map;

public class CodegenMakeableUtil {
    public static <T extends CodegenMakeable> CodegenExpression makeArray(String name, EPTypeClass clazz, T[] forges, Class generator, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        EPTypeClass arrayType = JavaClassHelper.getArrayType(clazz);
        if (forges == null || forges.length == 0) {
            return CodegenExpressionBuilder.newArrayByLength(clazz, CodegenExpressionBuilder.constant(0));
        }
        CodegenMethod method = parent.makeChild(arrayType, generator, (CodegenScope)classScope);
        method.getBlock().declareVar(arrayType, name, CodegenExpressionBuilder.newArrayByLength(clazz, CodegenExpressionBuilder.constant(forges.length)));
        for (int i = 0; i < forges.length; ++i) {
            method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref(name), CodegenExpressionBuilder.constant(i), forges[i] == null ? CodegenExpressionBuilder.constantNull() : forges[i].make(method, (SAIFFInitializeSymbol)symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref(name));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public static <K extends CodegenMakeable, V extends CodegenMakeable> CodegenExpression makeMap(String name, EPTypeClass clazzKey, EPTypeClass clazzValue, Map<K, V> map, Class generator, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (map.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyMap", new CodegenExpression[0]);
        }
        CodegenMethod method = parent.makeChild(EPTypePremade.MAP.getEPType(), generator, (CodegenScope)classScope);
        int count = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            String nameKey = "key" + count;
            String nameValue = "value" + count;
            method.getBlock().declareVar(clazzKey, nameKey, ((CodegenMakeable)entry.getKey()).make(method, symbols, classScope)).declareVar(clazzValue, nameValue, ((CodegenMakeable)entry.getValue()).make(method, symbols, classScope));
            ++count;
        }
        if (map.size() == 1) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, "singletonMap", CodegenExpressionBuilder.ref("key0"), CodegenExpressionBuilder.ref("value0")));
        } else {
            method.getBlock().declareVar(EPTypePremade.MAP.getEPType(), name, CodegenExpressionBuilder.newInstance(EPTypePremade.LINKEDHASHMAP.getEPType(), CodegenExpressionBuilder.constant(map.size())));
            for (int i = 0; i < map.size(); ++i) {
                method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(name), "put", CodegenExpressionBuilder.ref("key" + i), CodegenExpressionBuilder.ref("value" + i));
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.ref(name));
        }
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

