/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CombinationEnumeration
implements Enumeration<Object[]> {
    private final Object[][] combinations;
    private final Object[] prototype;
    private final int[] current;
    private boolean hasMore = true;

    public CombinationEnumeration(Object[][] combinations) {
        for (Object[] element : combinations) {
            if (element != null && element.length >= 1) continue;
            throw new IllegalArgumentException("Expecting non-null element of minimum length 1");
        }
        this.combinations = combinations;
        this.current = new int[combinations.length];
        this.prototype = new Object[combinations.length];
    }

    public static CombinationEnumeration fromZeroBasedRanges(int[] zeroBasedRanges) {
        Object[][] combinations = new Object[zeroBasedRanges.length][];
        for (int i = 0; i < zeroBasedRanges.length; ++i) {
            combinations[i] = new Integer[zeroBasedRanges[i]];
            for (int j = 0; j < zeroBasedRanges[i]; ++j) {
                combinations[i][j] = j;
            }
        }
        return new CombinationEnumeration(combinations);
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public Object[] nextElement() {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        this.populate();
        this.determineNext();
        return this.prototype;
    }

    private void determineNext() {
        for (int i = this.combinations.length - 1; i >= 0; --i) {
            int max = this.combinations[i].length;
            if (this.current[i] < max - 1) {
                int n = i;
                this.current[n] = this.current[n] + 1;
                return;
            }
            this.current[i] = 0;
        }
        this.hasMore = false;
    }

    private void populate() {
        for (int i = 0; i < this.prototype.length; ++i) {
            this.prototype[i] = this.combinations[i][this.current[i]];
        }
    }
}

