/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeySix;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class IntSeqKeyMany
implements IntSeqKey {
    private final int[] array;

    public IntSeqKeyMany(int[] array) {
        if (array.length < 7) {
            throw new IllegalArgumentException("Array size less than 7");
        }
        this.array = array;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (!(other instanceof IntSeqKeyMany)) {
            return false;
        }
        return IntArrayUtil.compareParentKey(((IntSeqKeyMany)other).array, this.array);
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyMany(IntArrayUtil.append(this.array, num));
    }

    @Override
    public IntSeqKey removeFromEnd() {
        if (this.array.length > 7) {
            return new IntSeqKeyMany(IntArrayUtil.getParentPath(this.array));
        }
        return new IntSeqKeySix(this.array[0], this.array[1], this.array[2], this.array[3], this.array[4], this.array[5]);
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public int last() {
        return this.array[this.array.length - 1];
    }

    @Override
    public int[] asIntArray() {
        return this.array;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyMany that = (IntSeqKeyMany)o;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public int[] getArray() {
        return this.array;
    }

    public static void write(IntSeqKeyMany key, DataOutput output) throws IOException {
        int[] array = key.getArray();
        output.writeInt(array.length);
        for (int i : array) {
            output.writeInt(i);
        }
    }

    public static IntSeqKeyMany read(DataInput input) throws IOException {
        int size = input.readInt();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = input.readInt();
        }
        return new IntSeqKeyMany(array);
    }
}

