/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class PermutationEnumeration
implements Enumeration<int[]> {
    private final int[] factors;
    private final int numElements;
    private final int maxNumPermutation;
    private int currentPermutation;

    public PermutationEnumeration(int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("Invalid element number of 1");
        }
        this.numElements = numElements;
        this.factors = PermutationEnumeration.getFactors(numElements);
        this.maxNumPermutation = PermutationEnumeration.faculty(numElements);
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentPermutation != this.maxNumPermutation;
    }

    @Override
    public int[] nextElement() {
        if (this.currentPermutation == this.maxNumPermutation) {
            throw new NoSuchElementException();
        }
        int[] element = PermutationEnumeration.getPermutation(this.numElements, this.currentPermutation, this.factors);
        ++this.currentPermutation;
        return element;
    }

    protected static int[] getPermutation(int numElements, int permutation, int[] factors) {
        int[] result = new int[numElements];
        ArrayList<Integer> outList = new ArrayList<Integer>();
        for (int i = 0; i < numElements; ++i) {
            outList.add(i);
        }
        int currentVal = permutation;
        for (int position = 0; position < numElements - 1; ++position) {
            int factor = factors[position];
            int index = currentVal / factor;
            result[position] = (Integer)outList.get(index);
            outList.remove(index);
            currentVal -= index * factor;
        }
        result[numElements - 1] = (Integer)outList.get(0);
        return result;
    }

    protected static int[] getFactors(int numElements) {
        int[] facultyFactors = new int[numElements];
        for (int i = 0; i < numElements - 1; ++i) {
            facultyFactors[i] = PermutationEnumeration.faculty(numElements - i - 1);
        }
        return facultyFactors;
    }

    protected static int faculty(int num) {
        if (num == 0) {
            return 0;
        }
        int fac = 1;
        for (int i = 1; i <= num; ++i) {
            fac *= i;
        }
        return fac;
    }
}

