/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.client.type.EPTypeClass;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCountedSetAtomicInteger<K> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(RefCountedSetAtomicInteger.class);
    private Map<K, Object> refs;

    public RefCountedSetAtomicInteger() {
        this.refs = new HashMap<K, Object>();
    }

    public RefCountedSetAtomicInteger(Map<K, Object> refs) {
        this.refs = refs;
    }

    public void clear() {
        this.refs.clear();
    }

    public boolean add(K key) {
        Object count = this.refs.get(key);
        if (count == null) {
            this.refs.put(key, 1);
            return true;
        }
        if (count instanceof AtomicInteger) {
            ((AtomicInteger)count).incrementAndGet();
            return false;
        }
        this.refs.put(key, new AtomicInteger(2));
        return false;
    }

    public boolean remove(K key) {
        Object count = this.refs.get(key);
        if (count == null) {
            return false;
        }
        if (count instanceof AtomicInteger) {
            int val = ((AtomicInteger)count).decrementAndGet();
            if (val == 0) {
                this.refs.remove(key);
                return true;
            }
            return false;
        }
        this.refs.remove(key);
        return true;
    }

    public void removeAll(K key) {
        this.refs.remove(key);
    }

    public boolean isEmpty() {
        return this.refs.isEmpty();
    }

    public Map<K, Object> getRefs() {
        return this.refs;
    }
}

