/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.MultiKeyArrayBoolean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayByte;
import com.espertech.esper.common.internal.collection.MultiKeyArrayChar;
import com.espertech.esper.common.internal.collection.MultiKeyArrayDouble;
import com.espertech.esper.common.internal.collection.MultiKeyArrayFloat;
import com.espertech.esper.common.internal.collection.MultiKeyArrayInt;
import com.espertech.esper.common.internal.collection.MultiKeyArrayLong;
import com.espertech.esper.common.internal.collection.MultiKeyArrayObject;
import com.espertech.esper.common.internal.collection.MultiKeyArrayShort;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefEmpty;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefPredetermined;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefUUIDBased;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefWSerde;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.StmtClassForgeableMultiKey;
import com.espertech.esper.common.internal.compile.multikey.StmtClassForgeableMultiKeySerde;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArraySerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArraySerdeFactory;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MultiKeyPlanner {
    public static boolean requiresDeepEquals(Class arrayComponentType) {
        return arrayComponentType == Object.class || arrayComponentType.isArray();
    }

    public static MultiKeyPlan planMultiKeyDistinct(boolean isDistinct, EventType eventType, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        if (!isDistinct) {
            return new MultiKeyPlan(Collections.emptyList(), MultiKeyClassRefEmpty.INSTANCE);
        }
        String[] propertyNames = eventType.getPropertyNames();
        EPType[] props = new EPType[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            props[i] = eventType.getPropertyEPType(propertyNames[i]);
        }
        return MultiKeyPlanner.planMultiKey(props, false, raw, serdeResolver);
    }

    public static MultiKeyPlan planMultiKey(ExprNode[] criteriaExpressions, boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        return MultiKeyPlanner.planMultiKey(ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions), lenientEquals, raw, serdeResolver);
    }

    public static MultiKeyPlan planMultiKey(ExprForge[] criteriaExpressions, boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        return MultiKeyPlanner.planMultiKey(ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions), lenientEquals, raw, serdeResolver);
    }

    public static EPTypeClass getMKClassForComponentType(EPTypeClass componentType) {
        Class<?> componentClass = componentType.getType();
        if (componentClass == Boolean.TYPE) {
            return MultiKeyArrayBoolean.EPTYPE;
        }
        if (componentClass == Byte.TYPE) {
            return MultiKeyArrayByte.EPTYPE;
        }
        if (componentClass == Character.TYPE) {
            return MultiKeyArrayChar.EPTYPE;
        }
        if (componentClass == Short.TYPE) {
            return MultiKeyArrayShort.EPTYPE;
        }
        if (componentClass == Integer.TYPE) {
            return MultiKeyArrayInt.EPTYPE;
        }
        if (componentClass == Long.TYPE) {
            return MultiKeyArrayLong.EPTYPE;
        }
        if (componentClass == Float.TYPE) {
            return MultiKeyArrayFloat.EPTYPE;
        }
        if (componentClass == Double.TYPE) {
            return MultiKeyArrayDouble.EPTYPE;
        }
        return MultiKeyArrayObject.EPTYPE;
    }

    public static DIOMultiKeyArraySerde getMKSerdeClassForComponentType(EPTypeClass componentType) {
        Class<?> componentClass = componentType.getType();
        if (componentClass.isPrimitive()) {
            return DIOMultiKeyArraySerdeFactory.getSerde(componentClass);
        }
        return DIOMultiKeyArraySerdeFactory.getSerde(Object.class);
    }

    public static MultiKeyPlan planMultiKey(EPType[] types, boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        if (types == null || types.length == 0) {
            return new MultiKeyPlan(Collections.emptyList(), MultiKeyClassRefEmpty.INSTANCE);
        }
        if (types.length == 1) {
            EPType paramType = types[0];
            if (paramType == null || paramType == EPTypeNull.INSTANCE || !((EPTypeClass)paramType).getType().isArray()) {
                DataInputOutputSerdeForge serdeForge = serdeResolver.serdeForKeyNonArray(paramType, raw);
                return new MultiKeyPlan(Collections.emptyList(), new MultiKeyClassRefWSerde(serdeForge, types));
            }
            EPTypeClass componentType = JavaClassHelper.getArrayComponentType((EPTypeClass)paramType);
            EPTypeClass mkClass = MultiKeyPlanner.getMKClassForComponentType(componentType);
            DIOMultiKeyArraySerde mkSerde = MultiKeyPlanner.getMKSerdeClassForComponentType(componentType);
            return new MultiKeyPlan(Collections.emptyList(), new MultiKeyClassRefPredetermined(mkClass, types, new DataInputOutputSerdeForgeSingleton(mkSerde.getClass()), mkSerde));
        }
        EPType[] boxed = new EPType[types.length];
        for (int i = 0; i < boxed.length; ++i) {
            boxed[i] = JavaClassHelper.getBoxedType(types[i]);
        }
        DataInputOutputSerdeForge[] forges = serdeResolver.serdeForMultiKey(boxed, raw);
        MultiKeyClassRefUUIDBased classNames = new MultiKeyClassRefUUIDBased(boxed, forges);
        StmtClassForgeableFactory factoryMK = (packageScope, classPostfix) -> new StmtClassForgeableMultiKey(classNames.getClassNameMK(classPostfix), packageScope, types, lenientEquals);
        StmtClassForgeableFactory factoryMKSerde = (packageScope, classPostfix) -> new StmtClassForgeableMultiKeySerde(classNames.getClassNameMKSerde(classPostfix), packageScope, types, classNames.getClassNameMK(classPostfix), forges);
        List<StmtClassForgeableFactory> forgeables = Arrays.asList(factoryMK, factoryMKSerde);
        return new MultiKeyPlan(forgeables, classNames);
    }

    public static Object toMultiKey(Object keyValue) {
        Class<?> componentType = keyValue.getClass().getComponentType();
        if (componentType == Boolean.TYPE) {
            return new MultiKeyArrayBoolean((boolean[])keyValue);
        }
        if (componentType == Byte.TYPE) {
            return new MultiKeyArrayByte((byte[])keyValue);
        }
        if (componentType == Character.TYPE) {
            return new MultiKeyArrayChar((char[])keyValue);
        }
        if (componentType == Short.TYPE) {
            return new MultiKeyArrayShort((short[])keyValue);
        }
        if (componentType == Integer.TYPE) {
            return new MultiKeyArrayInt((int[])keyValue);
        }
        if (componentType == Long.TYPE) {
            return new MultiKeyArrayLong((long[])keyValue);
        }
        if (componentType == Float.TYPE) {
            return new MultiKeyArrayFloat((float[])keyValue);
        }
        if (componentType == Double.TYPE) {
            return new MultiKeyArrayDouble((double[])keyValue);
        }
        return new MultiKeyArrayObject((Object[])keyValue);
    }
}

