/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.MultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class StmtClassForgeableMultiKey
implements StmtClassForgeable {
    private final String className;
    private final CodegenPackageScope packageScope;
    private final EPType[] types;
    private final boolean lenientEquals;

    public StmtClassForgeableMultiKey(String className, CodegenPackageScope packageScope, EPType[] types, boolean lenientEquals) {
        this.className = className;
        this.packageScope = packageScope;
        this.types = types;
        this.lenientEquals = lenientEquals;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        ArrayList<CodegenTypedParam> params = new ArrayList<CodegenTypedParam>();
        for (int i = 0; i < this.types.length; ++i) {
            EPType boxed = JavaClassHelper.getBoxedType(this.types[i]);
            params.add(new CodegenTypedParam(boxed == EPTypeNull.INSTANCE ? EPTypePremade.OBJECT.getEPType() : (EPTypeClass)boxed, "k" + i));
        }
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableMultiKey.class, includeDebugSymbols, params);
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod hashMethod = CodegenMethod.makeParentNode(EPTypePremade.INTEGERPRIMITIVE.getEPType(), StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        this.makeHashMethod(this.types.length, hashMethod);
        CodegenStackGenerator.recursiveBuildStack(hashMethod, "hashCode", methods);
        CodegenMethod equalsMethod = CodegenMethod.makeParentNode(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.OBJECT.getEPType(), "o");
        this.makeEqualsMethod(this.types.length, equalsMethod);
        CodegenStackGenerator.recursiveBuildStack(equalsMethod, "equals", methods);
        CodegenMethod getNumKeysMethod = CodegenMethod.makeParentNode(EPTypePremade.INTEGERPRIMITIVE.getEPType(), StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getNumKeysMethod.getBlock().methodReturn(CodegenExpressionBuilder.constant(this.types.length));
        CodegenStackGenerator.recursiveBuildStack(getNumKeysMethod, "getNumKeys", methods);
        CodegenMethod getKeyMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "num");
        this.makeGetKeyMethod(this.types.length, getKeyMethod);
        CodegenStackGenerator.recursiveBuildStack(getKeyMethod, "getKey", methods);
        CodegenMethod toStringMethod = CodegenMethod.makeParentNode(EPTypePremade.STRING.getEPType(), StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        this.makeToStringMethod(toStringMethod);
        CodegenStackGenerator.recursiveBuildStack(toStringMethod, "toString", methods);
        return new CodegenClass(CodegenClassType.KEYPROVISIONING, MultiKey.EPTYPE, this.className, classScope, Collections.emptyList(), ctor, methods, Collections.emptyList());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.MULTIKEY;
    }

    private void makeEqualsMethod(int length, CodegenMethod equalsMethod) {
        equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("this"), CodegenExpressionBuilder.ref("o"))).blockReturn(CodegenExpressionBuilder.constant(true));
        if (!this.lenientEquals) {
            equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("o")), CodegenExpressionBuilder.not(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("this"), "getClass", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("o"), "getClass", new CodegenExpression[0]))), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(false)).declareVar(this.className, "k", CodegenExpressionBuilder.cast(this.className, (CodegenExpression)CodegenExpressionBuilder.ref("o")));
            for (int i = 0; i < length; ++i) {
                CodegenExpressionRef self = CodegenExpressionBuilder.ref("k" + i);
                CodegenExpressionRef other = CodegenExpressionBuilder.ref("k.k" + i);
                if (i < length - 1) {
                    if (this.types[i] == EPTypeNull.INSTANCE) continue;
                    CodegenExpression notEquals = StmtClassForgeableMultiKey.getNotEqualsExpression((EPTypeClass)this.types[i], self, other);
                    equalsMethod.getBlock().ifCondition(notEquals).blockReturn(CodegenExpressionBuilder.constantFalse());
                    continue;
                }
                if (this.types[i] != EPTypeNull.INSTANCE) {
                    CodegenExpression equals = StmtClassForgeableMultiKey.getEqualsExpression((EPTypeClass)this.types[i], self, other);
                    equalsMethod.getBlock().methodReturn(equals);
                    continue;
                }
                equalsMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
            }
            return;
        }
        equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("o"), MultiKey.EPTYPE))).blockReturn(CodegenExpressionBuilder.constant(false)).declareVar(MultiKey.EPTYPE, "k", CodegenExpressionBuilder.cast(MultiKey.EPTYPE, (CodegenExpression)CodegenExpressionBuilder.ref("o")));
        for (int i = 0; i < length; ++i) {
            CodegenExpressionRef self = CodegenExpressionBuilder.ref("k" + i);
            CodegenExpression other = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("k"), "getKey", CodegenExpressionBuilder.constant(i));
            if (this.types[i] != EPTypeNull.INSTANCE) {
                EPTypeClass type = (EPTypeClass)this.types[i];
                if (type.getType().isArray()) {
                    other = CodegenExpressionBuilder.cast(type, other);
                }
                if (i < length - 1) {
                    CodegenExpression notEquals = StmtClassForgeableMultiKey.getNotEqualsExpression(type, self, other);
                    equalsMethod.getBlock().ifCondition(notEquals).blockReturn(CodegenExpressionBuilder.constantFalse());
                    continue;
                }
                CodegenExpression equals = StmtClassForgeableMultiKey.getEqualsExpression(type, self, other);
                equalsMethod.getBlock().methodReturn(equals);
                continue;
            }
            if (i < length - 1) continue;
            equalsMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
        }
    }

    private void makeGetKeyMethod(int length, CodegenMethod method) {
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("num"), length, true);
        for (int i = 0; i < length; ++i) {
            blocks[i].blockReturn(CodegenExpressionBuilder.ref("k" + i));
        }
    }

    private static CodegenExpression getEqualsExpression(EPTypeClass type, CodegenExpressionRef self, CodegenExpression other) {
        if (!type.getType().isArray()) {
            CodegenExpression cond = CodegenExpressionBuilder.notEqualsNull(self);
            CodegenExpression condTrue = CodegenExpressionBuilder.exprDotMethod(self, "equals", other);
            CodegenExpression condFalse = CodegenExpressionBuilder.equalsNull(other);
            return CodegenExpressionBuilder.conditional(cond, condTrue, condFalse);
        }
        if (MultiKeyPlanner.requiresDeepEquals(type.getType().getComponentType())) {
            return CodegenExpressionBuilder.staticMethod(Arrays.class, "deepEquals", self, other);
        }
        return CodegenExpressionBuilder.staticMethod(Arrays.class, "equals", self, other);
    }

    private static CodegenExpression getNotEqualsExpression(EPTypeClass type, CodegenExpressionRef self, CodegenExpression other) {
        if (!type.getType().isArray()) {
            CodegenExpression cond = CodegenExpressionBuilder.notEqualsNull(self);
            CodegenExpression condTrue = CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(self, "equals", other));
            CodegenExpression condFalse = CodegenExpressionBuilder.notEqualsNull(other);
            return CodegenExpressionBuilder.conditional(cond, condTrue, condFalse);
        }
        if (MultiKeyPlanner.requiresDeepEquals(type.getType().getComponentType())) {
            return CodegenExpressionBuilder.not(CodegenExpressionBuilder.staticMethod(Arrays.class, "deepEquals", self, other));
        }
        return CodegenExpressionBuilder.not(CodegenExpressionBuilder.staticMethod(Arrays.class, "equals", self, other));
    }

    private void makeHashMethod(int length, CodegenMethod hashMethod) {
        CodegenExpression computeHash = StmtClassForgeableMultiKey.getHashExpression(CodegenExpressionBuilder.ref("k0"), this.types[0]);
        hashMethod.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "h", computeHash);
        for (int i = 1; i < length; ++i) {
            computeHash = StmtClassForgeableMultiKey.getHashExpression(CodegenExpressionBuilder.ref("k" + i), this.types[i]);
            hashMethod.getBlock().assignRef("h", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(31), "*", CodegenExpressionBuilder.ref("h")), "+", computeHash));
        }
        hashMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("h"));
    }

    private static CodegenExpression getHashExpression(CodegenExpressionRef key, EPType type) {
        if (type == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constant(0);
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        if (!typeClass.getType().isArray()) {
            return CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.notEqualsNull(key), CodegenExpressionBuilder.exprDotMethod(key, "hashCode", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0));
        }
        if (MultiKeyPlanner.requiresDeepEquals(typeClass.getType().getComponentType())) {
            return CodegenExpressionBuilder.staticMethod(Arrays.class, "deepHashCode", key);
        }
        return CodegenExpressionBuilder.staticMethod(Arrays.class, "hashCode", key);
    }

    private void makeToStringMethod(CodegenMethod toStringMethod) {
        toStringMethod.getBlock().declareVarNewInstance(EPTypePremade.STRINGBUILDER.getEPType(), "b").exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant(MultiKey.class.getSimpleName() + "["));
        for (int i = 0; i < this.types.length; ++i) {
            CodegenExpressionRef self;
            if (i > 0) {
                toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant(","));
            }
            CodegenExpression text = self = CodegenExpressionBuilder.ref("k" + i);
            if (this.types[i] == EPTypeNull.INSTANCE) {
                toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant("null"));
                continue;
            }
            if (((EPTypeClass)this.types[i]).getType().isArray()) {
                text = CodegenExpressionBuilder.staticMethod(Arrays.class, "toString", self);
            }
            toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", text);
        }
        toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant("]")).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b"), "toString", new CodegenExpression[0]));
    }
}

