/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage1.spec;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecBase;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecOptions;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootForgeNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMapMeta;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class PatternStreamSpecCompiled
extends StreamSpecBase
implements StreamSpecCompiled {
    private final EvalRootForgeNode root;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final LinkedHashSet<String> allTags;
    private final boolean suppressSameEventMatches;
    private final boolean discardPartialsOnMatch;

    public PatternStreamSpecCompiled(EvalRootForgeNode root, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTags, ViewSpec[] viewSpecs, String optionalStreamName, StreamSpecOptions streamSpecOptions, boolean suppressSameEventMatches, boolean discardPartialsOnMatch) {
        super(optionalStreamName, viewSpecs, streamSpecOptions);
        this.suppressSameEventMatches = suppressSameEventMatches;
        this.discardPartialsOnMatch = discardPartialsOnMatch;
        this.root = root;
        this.allTags = allTags;
        LinkedHashMap<String, Pair<EventType, String>> copy = new LinkedHashMap<String, Pair<EventType, String>>();
        copy.putAll(taggedEventTypes);
        this.taggedEventTypes = copy;
        copy = new LinkedHashMap();
        copy.putAll(arrayEventTypes);
        this.arrayEventTypes = copy;
    }

    public EvalRootForgeNode getRoot() {
        return this.root;
    }

    public boolean isConsumingFilters() {
        return this.isConsumingFiltersRecursive(this.root);
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getArrayEventTypes() {
        return this.arrayEventTypes;
    }

    public MatchedEventMapMeta getMatchedEventMapMeta() {
        String[] tags = new String[this.allTags.size()];
        EventType[] eventTypes = new EventType[this.allTags.size()];
        int count = 0;
        Iterator iterator = this.allTags.iterator();
        while (iterator.hasNext()) {
            String tag;
            tags[count] = tag = (String)iterator.next();
            EventType eventType = null;
            Pair<EventType, String> nonArray = this.taggedEventTypes.get(tag);
            if (nonArray != null) {
                eventType = nonArray.getFirst();
            } else {
                Pair<EventType, String> array = this.arrayEventTypes.get(tag);
                if (array != null) {
                    eventType = array.getFirst();
                }
            }
            if (eventType == null) {
                throw new IllegalStateException("Failed to find tag '" + tag + "' among type information");
            }
            eventTypes[count++] = eventType;
        }
        String[] arrayTags = this.arrayEventTypes.isEmpty() ? null : this.arrayEventTypes.keySet().toArray(new String[0]);
        return new MatchedEventMapMeta(tags, eventTypes, arrayTags);
    }

    public LinkedHashSet<String> getAllTags() {
        return this.allTags;
    }

    public boolean isSuppressSameEventMatches() {
        return this.suppressSameEventMatches;
    }

    public boolean isDiscardPartialsOnMatch() {
        return this.discardPartialsOnMatch;
    }

    private boolean isConsumingFiltersRecursive(EvalForgeNode evalNode) {
        if (evalNode instanceof EvalFilterForgeNode) {
            return ((EvalFilterForgeNode)evalNode).getConsumptionLevel() != null;
        }
        boolean consumption = false;
        for (EvalForgeNode child : evalNode.getChildNodes()) {
            consumption = consumption || this.isConsumingFiltersRecursive(child);
        }
        return consumption;
    }
}

