/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HookType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.PropertyEvalSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompileHook;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiledDesc;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlanner;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerUnwindAndOr;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecValidatedDesc;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.contained.PropertyEvaluatorForge;
import com.espertech.esper.common.internal.epl.contained.PropertyEvaluatorForgeFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperFilters;
import com.espertech.esper.common.internal.settings.ClasspathImportUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterSpecCompiler {
    private static final Logger log = LoggerFactory.getLogger(FilterSpecCompiler.class);
    public static final String NEWLINE = System.getProperty("line.separator");

    public static FilterSpecCompiledDesc makeFilterSpec(EventType eventType, String eventTypeName, List<ExprNode> filterExpessions, PropertyEvalSpec optionalPropertyEvalSpec, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StreamTypeService streamTypeService, String optionalStreamName, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        FilterSpecValidatedDesc validatedDesc = FilterSpecCompiler.validateAllowSubquery(ExprNodeOrigin.FILTER, filterExpessions, streamTypeService, taggedEventTypes, arrayEventTypes, statementRawInfo, services);
        return FilterSpecCompiler.build(validatedDesc, eventType, eventTypeName, optionalPropertyEvalSpec, taggedEventTypes, arrayEventTypes, allTagNamesOrdered, streamTypeService, optionalStreamName, statementRawInfo, services);
    }

    public static FilterSpecCompiledDesc build(FilterSpecValidatedDesc validatedDesc, EventType eventType, String eventTypeName, PropertyEvalSpec optionalPropertyEvalSpec, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StreamTypeService streamTypeService, String optionalStreamName, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        FilterSpecCompiled compiled = FilterSpecCompiler.buildNoStmtCtx(validatedDesc.getExpressions(), eventType, eventTypeName, optionalStreamName, optionalPropertyEvalSpec, taggedEventTypes, arrayEventTypes, allTagNamesOrdered, streamTypeService, statementRawInfo, compileTimeServices);
        return new FilterSpecCompiledDesc(compiled, validatedDesc.getAdditionalForgeables());
    }

    public static FilterSpecCompiled buildNoStmtCtx(List<ExprNode> validatedNodes, EventType eventType, String eventTypeName, String optionalStreamName, PropertyEvalSpec optionalPropertyEvalSpec, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StreamTypeService streamTypeService, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        PropertyEvaluatorForge optionalPropertyEvaluator = null;
        if (optionalPropertyEvalSpec != null) {
            optionalPropertyEvaluator = PropertyEvaluatorForgeFactory.makeEvaluator(optionalPropertyEvalSpec, eventType, optionalStreamName, statementRawInfo, compileTimeServices);
        }
        List<ExprNode> unwound = FilterSpecCompilerIndexPlannerUnwindAndOr.unwindAndOr(validatedNodes);
        FilterSpecCompilerArgs args = new FilterSpecCompilerArgs(taggedEventTypes, arrayEventTypes, allTagNamesOrdered, streamTypeService, null, statementRawInfo, compileTimeServices);
        FilterSpecPlanForge plan = FilterSpecCompilerIndexPlanner.planFilterParameters(unwound, args);
        FilterSpecCompileHook hook = (FilterSpecCompileHook)ClasspathImportUtil.getAnnotationHook(statementRawInfo.getAnnotations(), HookType.INTERNAL_FILTERSPEC, FilterSpecCompileHook.class, compileTimeServices.getClasspathImportServiceCompileTime());
        if (hook != null) {
            hook.filterIndexPlan(eventType, unwound, plan);
        }
        if (compileTimeServices.getConfiguration().getCompiler().getLogging().isEnableFilterPlan()) {
            FilterSpecCompiler.logFilterPlans(unwound, plan, eventType, optionalStreamName, statementRawInfo);
        }
        if (log.isDebugEnabled()) {
            log.debug(".makeFilterSpec spec=" + plan);
        }
        return new FilterSpecCompiled(eventType, eventTypeName, plan, optionalPropertyEvaluator);
    }

    public static FilterSpecValidatedDesc validateAllowSubquery(ExprNodeOrigin exprNodeOrigin, List<ExprNode> exprNodes, StreamTypeService streamTypeService, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        ArrayList<ExprNode> validatedNodes = new ArrayList<ExprNode>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, statementRawInfo, services).withAllowBindingConsumption(true).withIsFilterExpression(true).build();
        for (ExprNode node : exprNodes) {
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            node.accept(visitor);
            if (!visitor.getSubselects().isEmpty()) {
                for (ExprSubselectNode subselect : visitor.getSubselects()) {
                    try {
                        List<StmtClassForgeableFactory> subselectAdditionalForgeables = SubSelectHelperFilters.handleSubselectSelectClauses(subselect, streamTypeService.getEventTypes()[0], streamTypeService.getStreamNames()[0], streamTypeService.getStreamNames()[0], taggedEventTypes, arrayEventTypes, statementRawInfo, services);
                        additionalForgeables.addAll(subselectAdditionalForgeables);
                    }
                    catch (ExprValidationException ex) {
                        throw new ExprValidationException("Failed to validate " + ExprNodeUtilityMake.getSubqueryInfoText(subselect) + ": " + ex.getMessage(), ex);
                    }
                }
            }
            ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(exprNodeOrigin, node, validationContext);
            validatedNodes.add(validated);
            if (JavaClassHelper.isTypeBoolean(validated.getForge().getEvaluationType())) continue;
            throw new ExprValidationException("Filter expression not returning a boolean value: '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(validated) + "'");
        }
        return new FilterSpecValidatedDesc(validatedNodes, additionalForgeables);
    }

    private static void logFilterPlans(List<ExprNode> validatedNodes, FilterSpecPlanForge plan, EventType eventType, String optionalStreamName, StatementRawInfo statementRawInfo) {
        StringBuilder buf = new StringBuilder();
        buf.append("Filter plan for statement '").append(statementRawInfo.getStatementName()).append("' filtering event type '").append(eventType.getName() + "'");
        if (optionalStreamName != null) {
            buf.append(" alias '" + optionalStreamName + "'");
        }
        if (validatedNodes.isEmpty()) {
            buf.append(" empty");
        } else {
            ExprNode andNode = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(validatedNodes);
            String expression = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(andNode);
            buf.append(" expression '").append(expression).append("' for ").append(plan.getPaths().length).append(" paths");
        }
        buf.append(NEWLINE);
        plan.appendPlan(buf);
        log.info(buf.toString());
    }
}

