/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiler;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPath;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTriplet;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;

public class FilterSpecPlanPathForge {
    private final FilterSpecPlanPathTripletForge[] triplets;
    private ExprNode pathNegate;

    public FilterSpecPlanPathForge(FilterSpecPlanPathTripletForge[] triplets, ExprNode pathNegate) {
        this.triplets = triplets;
        this.pathNegate = pathNegate;
    }

    public FilterSpecPlanPathTripletForge[] getTriplets() {
        return this.triplets;
    }

    public ExprNode getPathNegate() {
        return this.pathNegate;
    }

    public void setPathNegate(ExprNode pathNegate) {
        this.pathNegate = pathNegate;
    }

    public boolean equalsFilter(FilterSpecPlanPathForge other) {
        if (this.triplets.length != other.getTriplets().length) {
            return false;
        }
        for (int i = 0; i < this.triplets.length; ++i) {
            FilterSpecPlanPathTripletForge mytriplet = this.triplets[i];
            FilterSpecPlanPathTripletForge othertriplet = other.triplets[i];
            if (mytriplet.equalsFilter(othertriplet)) continue;
            return false;
        }
        return ExprNodeUtilityCompare.deepEqualsNullChecked(this.pathNegate, other.pathNegate, true);
    }

    public CodegenMethod codegen(CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(FilterSpecPlanPath.EPTYPE, FilterSpecParamForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(FilterSpecPlanPathTriplet.EPTYPEARRAY, "triplets", CodegenExpressionBuilder.newArrayByLength(FilterSpecPlanPathTriplet.EPTYPE, CodegenExpressionBuilder.constant(this.triplets.length)));
        for (int i = 0; i < this.triplets.length; ++i) {
            CodegenMethod triplet = this.triplets[i].codegen(method, symbols, classScope);
            method.getBlock().assignArrayElement("triplets", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(triplet, new CodegenExpression[0]));
        }
        method.getBlock().declareVarNewInstance(FilterSpecPlanPath.EPTYPE, "path").exprDotMethod(CodegenExpressionBuilder.ref("path"), "setTriplets", CodegenExpressionBuilder.ref("triplets")).exprDotMethod(CodegenExpressionBuilder.ref("path"), "setPathNegate", FilterSpecPlanForge.optionalEvaluator(this.pathNegate, method, classScope)).methodReturn(CodegenExpressionBuilder.ref("path"));
        return method;
    }

    protected void appendFilterPlanPath(int indexPath, StringBuilder buf) {
        buf.append("  -path #").append(indexPath).append(" there are ").append(this.triplets.length).append(" triplets").append(FilterSpecCompiler.NEWLINE);
        if (this.pathNegate != null) {
            buf.append("    -path-negate-expression: ").append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.pathNegate)).append(FilterSpecCompiler.NEWLINE);
        }
        int indextriplet = 0;
        for (FilterSpecPlanPathTripletForge forge : this.triplets) {
            forge.appendFilterPlanTriplet(indextriplet, buf);
            ++indextriplet;
        }
    }
}

