/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseExpressions;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiledDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.specmapper.ExpressionCopier;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiledDesc;
import com.espertech.esper.common.internal.compile.stage2.StreamSpecCompiler;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByExpressionHelper;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeViewResourceVisitor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPatternExpandUtil;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNode;
import com.espertech.esper.common.internal.epl.util.StatementSpecRawWalkerSubselectAndDeclaredDot;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementRawCompiler {
    private static final Logger log = LoggerFactory.getLogger(StatementRawCompiler.class);

    /*
     * WARNING - void declaration
     */
    public static StatementSpecCompiledDesc compile(StatementSpecRaw spec, Compilable compilable, boolean isSubquery, boolean isOnDemandQuery, Annotation[] annotations, List<ExprSubselectNode> subselectNodes, List<ExprTableAccessNode> tableAccessNodes, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws StatementSpecCompileException {
        ArrayList<StreamSpecCompiled> compiledStreams;
        GroupByClauseExpressions groupByRollupExpressions;
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        if (!isOnDemandQuery && spec.getFireAndForgetSpec() != null) {
            throw new StatementSpecCompileException("Provided EPL expression is an on-demand query expression (not a continuous query)", compilable.toEPL());
        }
        if (spec.getStreamSpecs().size() == 1 && spec.getStreamSpecs().get(0) instanceof FilterStreamSpecRaw && spec.getStreamSpecs().get(0).getViewSpecs().length == 0 && spec.getWhereClause() != null && spec.getOnTriggerDesc() == null && !isSubquery && !isOnDemandQuery && (tableAccessNodes == null || tableAccessNodes.isEmpty())) {
            FilterStreamSpecRaw streamSpec;
            boolean disqualified;
            ExprNode whereClause = spec.getWhereClause();
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            whereClause.accept(visitor);
            boolean bl = disqualified = visitor.getSubselects().size() > 0 || HintEnum.DISABLE_WHEREEXPR_MOVETO_FILTER.getHint(annotations) != null;
            if (!disqualified) {
                ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
                whereClause.accept(viewResourceVisitor);
                boolean bl2 = disqualified = viewResourceVisitor.getExprNodes().size() > 0;
            }
            if ((streamSpec = (FilterStreamSpecRaw)spec.getStreamSpecs().get(0)).getRawFilterSpec().getOptionalPropertyEvalSpec() != null) {
                disqualified = true;
            }
            if (!disqualified) {
                spec.setWhereClause(null);
                streamSpec.getRawFilterSpec().getFilterExpressions().add(whereClause);
            }
        }
        SelectClauseSpecCompiled selectClauseCompiled = StatementRawCompiler.compileSelectClause(spec.getSelectClauseSpec());
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        try {
            StatementSpecRawWalkerSubselectAndDeclaredDot.walkStreamSpecs(spec, visitor);
        }
        catch (ExprValidationException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), ex, compilable.toEPL());
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            subselectNode.setFilterStreamSubselect(true);
        }
        visitor.reset();
        try {
            StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectAndDeclaredDotExpr(spec, visitor);
            ExpressionCopier expressionCopier = new ExpressionCopier(spec, statementRawInfo.getOptionalContextDescriptor(), compileTimeServices, visitor);
            groupByRollupExpressions = GroupByExpressionHelper.getGroupByRollupExpressions(spec.getGroupByExpressions(), spec.getSelectClauseSpec(), spec.getHavingClause(), spec.getOrderByList(), expressionCopier);
        }
        catch (ExprValidationException ex) {
            throw new StatementSpecCompileException(ex.getMessage(), ex, compilable.toEPL());
        }
        if (spec.getMatchRecognizeSpec() != null) {
            RowRecogExprNode expandedPatternNode;
            try {
                ExpressionCopier expressionCopier = new ExpressionCopier(spec, statementRawInfo.getOptionalContextDescriptor(), compileTimeServices, visitor);
                expandedPatternNode = RowRecogPatternExpandUtil.expand(spec.getMatchRecognizeSpec().getPattern(), expressionCopier);
            }
            catch (ExprValidationException exprValidationException) {
                throw new StatementSpecCompileException(exprValidationException.getMessage(), exprValidationException, compilable.toEPL());
            }
            spec.getMatchRecognizeSpec().setPattern(expandedPatternNode);
        }
        if (isSubquery && !visitor.getSubselects().isEmpty()) {
            throw new StatementSpecCompileException("Invalid nested subquery, subquery-within-subquery is not supported", compilable.toEPL());
        }
        for (ExprSubselectNode exprSubselectNode : visitor.getSubselects()) {
            if (subselectNodes.contains(exprSubselectNode)) continue;
            subselectNodes.add(exprSubselectNode);
        }
        int subselectNumber = 0;
        for (ExprSubselectNode exprSubselectNode : subselectNodes) {
            StatementSpecRaw statementSpecRaw = exprSubselectNode.getStatementSpecRaw();
            StatementSpecCompiledDesc desc = StatementRawCompiler.compile(statementSpecRaw, compilable, true, isOnDemandQuery, annotations, Collections.emptyList(), Collections.emptyList(), statementRawInfo, compileTimeServices);
            additionalForgeables.addAll(desc.getAdditionalForgeables());
            exprSubselectNode.setStatementSpecCompiled(desc.getCompiled(), subselectNumber);
            ++subselectNumber;
        }
        boolean bl = false;
        for (ExprTableAccessNode exprTableAccessNode : tableAccessNodes) {
            void var15_24;
            exprTableAccessNode.setTableAccessNumber((int)var15_24);
            ++var15_24;
        }
        try {
            compiledStreams = new ArrayList<StreamSpecCompiled>(spec.getStreamSpecs().size());
            boolean bl3 = false;
            for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
                void var16_28;
                StreamSpecCompiledDesc desc = StreamSpecCompiler.compile(rawSpec, spec.getStreamSpecs().size() > 1, false, spec.getOnTriggerDesc() != null, rawSpec.getOptionalStreamName(), (int)(++var16_28), statementRawInfo, compileTimeServices);
                additionalForgeables.addAll(desc.getAdditionalForgeables());
                compiledStreams.add(desc.getStreamSpecCompiled());
            }
        }
        catch (ExprValidationException exprValidationException) {
            if (exprValidationException.getMessage() == null) {
                throw new StatementSpecCompileException("Unexpected exception compiling statement, please consult the log file and report the exception", exprValidationException, compilable.toEPL());
            }
            throw new StatementSpecCompileException(exprValidationException.getMessage(), exprValidationException, compilable.toEPL());
        }
        catch (EPException ePException) {
            throw new StatementSpecCompileException(ePException.getMessage(), ePException, compilable.toEPL());
        }
        catch (RuntimeException runtimeException) {
            String string = "Unexpected error compiling statement";
            log.error(string, (Throwable)runtimeException);
            throw new StatementSpecCompileException(string + ": " + runtimeException.getClass().getName() + ":" + runtimeException.getMessage(), runtimeException, compilable.toEPL());
        }
        StatementSpecCompiled statementSpecCompiled = new StatementSpecCompiled(spec, compiledStreams.toArray(new StreamSpecCompiled[compiledStreams.size()]), selectClauseCompiled, annotations, groupByRollupExpressions, subselectNodes, visitor.getDeclaredExpressions(), tableAccessNodes);
        return new StatementSpecCompiledDesc(statementSpecCompiled, additionalForgeables);
    }

    public static SelectClauseSpecCompiled compileSelectClause(SelectClauseSpecRaw spec) {
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw;
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).isEvents()));
                continue;
            }
            if (raw instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw.getClass().getName());
        }
        return new SelectClauseSpecCompiled(selectElements.toArray(new SelectClauseElementCompiled[selectElements.size()]), spec.isDistinct());
    }
}

