/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import java.io.StringWriter;
import java.lang.annotation.Annotation;

public class StatementRawInfo {
    private final int statementNumber;
    private final String statementName;
    private final Annotation[] annotations;
    private final StatementType statementType;
    private final ContextCompileTimeDescriptor optionalContextDescriptor;
    private final String intoTableName;
    private final Compilable compilable;
    private final String moduleName;

    public StatementRawInfo(int statementNumber, String statementName, Annotation[] annotations, StatementType statementType, ContextCompileTimeDescriptor optionalContextDescriptor, String intoTableName, Compilable compilable, String moduleName) {
        this.statementNumber = statementNumber;
        this.statementName = statementName;
        this.annotations = annotations;
        this.statementType = statementType;
        this.optionalContextDescriptor = optionalContextDescriptor;
        this.intoTableName = intoTableName;
        this.compilable = compilable;
        this.moduleName = moduleName;
    }

    public int getStatementNumber() {
        return this.statementNumber;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public ContextCompileTimeDescriptor getOptionalContextDescriptor() {
        return this.optionalContextDescriptor;
    }

    public String getContextName() {
        return this.optionalContextDescriptor == null ? null : this.optionalContextDescriptor.getContextName();
    }

    public String getIntoTableName() {
        return this.intoTableName;
    }

    public Compilable getCompilable() {
        return this.compilable;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void appendCodeDebugInfo(StringWriter writer) {
        writer.append("statement ").append(Integer.toString(this.statementNumber)).append(" name ").append(this.statementName.replace("\\", ""));
    }
}

