/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage3;

import com.espertech.esper.common.client.annotation.Drop;
import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.Priority;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.client.util.StatementProperty;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionScriptProvided;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.stage2.StatementLifecycleSvcUtil;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecWalkUtil;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.context.module.StatementInformationalsCompileTime;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectSubscriberDescriptor;
import com.espertech.esper.common.internal.epl.util.StatementSpecRawWalkerExpr;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StatementInformationalsUtil {
    public static final String EPL_ONSTART_SCRIPT_NAME = "on_statement_start";
    public static final String EPL_ONSTOP_SCRIPT_NAME = "on_statement_stop";
    public static final String EPL_ONLISTENERUPDATE_SCRIPT_NAME = "on_statement_listener_update";

    public static StatementInformationalsCompileTime getInformationals(StatementBaseInfo base, List<FilterSpecTracked> filterSpecCompileds, List<ScheduleHandleTracked> schedules, List<NamedWindowConsumerStreamSpec> namedWindowConsumers, boolean allowContext, SelectSubscriberDescriptor selectSubscriberDescriptor, CodegenPackageScope packageScope, StatementCompileTimeServices services) {
        ContextCompileTimeDescriptor descriptor;
        StatementSpecCompiled specCompiled = base.getStatementSpec();
        boolean alwaysSynthesizeOutputEvents = specCompiled.getRaw().getInsertIntoDesc() != null | specCompiled.getRaw().getForClauseSpec() != null || specCompiled.getSelectClauseCompiled().isDistinct() || specCompiled.getRaw().getCreateDataFlowDesc() != null;
        boolean needDedup = StatementInformationalsUtil.isNeedDedup(filterSpecCompileds);
        boolean hasSubquery = !base.getStatementSpec().getSubselectNodes().isEmpty();
        boolean canSelfJoin = StatementSpecWalkUtil.isPotentialSelfJoin(specCompiled) || needDedup;
        boolean stateless = StatementInformationalsUtil.determineStatelessSelect(base.getStatementRawInfo().getStatementType(), base.getStatementSpec().getRaw(), !base.getStatementSpec().getSubselectNodes().isEmpty());
        String contextName = null;
        String contextModuleName = null;
        NameAccessModifier contextVisibility = null;
        if (allowContext && (descriptor = base.getStatementRawInfo().getOptionalContextDescriptor()) != null) {
            contextName = descriptor.getContextName();
            contextModuleName = descriptor.getContextModuleName();
            contextVisibility = descriptor.getContextVisibility();
        }
        AnnotationAnalysisResult annotationData = AnnotationAnalysisResult.analyzeAnnotations(base.getStatementSpec().getAnnotations());
        boolean hasHint = false;
        if (base.getStatementSpec().getRaw().getAnnotations() != null) {
            for (Annotation annotation : base.getStatementRawInfo().getAnnotations()) {
                if (!(annotation instanceof Hint)) continue;
                hasHint = true;
            }
        }
        boolean hasVariables = hasHint || !base.getStatementSpec().getRaw().getReferencedVariables().isEmpty() || base.getStatementSpec().getRaw().getCreateContextDesc() != null;
        boolean writesToTables = StatementLifecycleSvcUtil.isWritesToTables(base.getStatementSpec().getRaw(), services.getTableCompileTimeResolver());
        boolean hasTableAccess = StatementLifecycleSvcUtil.determineHasTableAccess(base.getStatementSpec().getSubselectNodes(), base.getStatementSpec().getRaw(), services.getTableCompileTimeResolver());
        HashMap<StatementProperty, Object> properties = new HashMap<StatementProperty, Object>();
        if (services.getConfiguration().getCompiler().getByteCode().isAttachEPL()) {
            properties.put(StatementProperty.EPL, base.getCompilable().toEPL());
        }
        String insertIntoLatchName = null;
        if (base.getStatementSpec().getRaw().getInsertIntoDesc() != null || base.getStatementSpec().getRaw().getOnTriggerDesc() instanceof OnTriggerMergeDesc) {
            insertIntoLatchName = base.getStatementSpec().getRaw().getInsertIntoDesc() != null ? base.getStatementSpec().getRaw().getInsertIntoDesc().getEventTypeName() : "merge";
        }
        boolean allowSubscriber = services.getConfiguration().getCompiler().getByteCode().isAllowSubscriber();
        List<ExpressionScriptProvided> statementScripts = base.getStatementSpec().getRaw().getScriptExpressions();
        ArrayList<ExpressionScriptProvided> onScripts = new ArrayList<ExpressionScriptProvided>(2);
        if (statementScripts != null) {
            for (ExpressionScriptProvided script : statementScripts) {
                if (!script.getName().equals(EPL_ONLISTENERUPDATE_SCRIPT_NAME) && !script.getName().equals(EPL_ONSTART_SCRIPT_NAME) && !script.getName().equals(EPL_ONSTOP_SCRIPT_NAME)) continue;
                onScripts.add(script);
            }
        }
        return new StatementInformationalsCompileTime(base.getStatementName(), alwaysSynthesizeOutputEvents, contextName, contextModuleName, contextVisibility, canSelfJoin, hasSubquery, needDedup, specCompiled.getAnnotations(), stateless, base.getUserObjectCompileTime(), filterSpecCompileds.size(), schedules.size(), namedWindowConsumers.size(), base.getStatementRawInfo().getStatementType(), annotationData.getPriority(), annotationData.isPremptive(), hasVariables, writesToTables, hasTableAccess, selectSubscriberDescriptor.getSelectClauseTypes(), selectSubscriberDescriptor.getSelectClauseColumnNames(), selectSubscriberDescriptor.isForClauseDelivery(), selectSubscriberDescriptor.getGroupDelivery(), selectSubscriberDescriptor.getGroupDeliveryMultiKey(), properties, base.getStatementSpec().getRaw().getMatchRecognizeSpec() != null, services.isInstrumented(), packageScope, insertIntoLatchName, allowSubscriber, onScripts.toArray(new ExpressionScriptProvided[0]));
    }

    private static boolean isNeedDedup(List<FilterSpecTracked> filterSpecCompileds) {
        for (FilterSpecTracked provider : filterSpecCompileds) {
            if (provider.getFilterSpecCompiled().getParameters().getPaths().length <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean determineStatelessSelect(StatementType type, StatementSpecRaw spec, boolean hasSubselects) {
        if (hasSubselects) {
            return false;
        }
        if (type != StatementType.SELECT) {
            return false;
        }
        if (spec.getStreamSpecs() == null || spec.getStreamSpecs().size() > 1 || spec.getStreamSpecs().isEmpty()) {
            return false;
        }
        StreamSpecRaw singleStream = spec.getStreamSpecs().get(0);
        if (!(singleStream instanceof FilterStreamSpecRaw) && !(singleStream instanceof NamedWindowConsumerStreamSpec)) {
            return false;
        }
        if (singleStream.getViewSpecs() != null && singleStream.getViewSpecs().length > 0) {
            return false;
        }
        if (spec.getOutputLimitSpec() != null) {
            return false;
        }
        if (spec.getMatchRecognizeSpec() != null) {
            return false;
        }
        List<ExprNode> expressions = StatementSpecRawWalkerExpr.collectExpressionsShallow(spec);
        if (expressions.isEmpty()) {
            return true;
        }
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        for (ExprNode expr : expressions) {
            if (expr == null) continue;
            expr.accept(visitor);
        }
        return !visitor.isHasAggregation() && !visitor.isHasPreviousPrior() && !visitor.isHasSubselect();
    }

    public static class AnnotationAnalysisResult {
        private int priority;
        private boolean isPremptive;

        private AnnotationAnalysisResult(int priority, boolean premptive) {
            this.priority = priority;
            this.isPremptive = premptive;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isPremptive() {
            return this.isPremptive;
        }

        public static AnnotationAnalysisResult analyzeAnnotations(Annotation[] annotations) {
            boolean preemptive = false;
            int priority = 0;
            boolean hasPrioritySetting = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Priority) {
                    priority = ((Priority)annotation).value();
                    hasPrioritySetting = true;
                }
                if (!(annotation instanceof Drop)) continue;
                preemptive = true;
            }
            if (!hasPrioritySetting && preemptive) {
                priority = 1;
            }
            return new AnnotationAnalysisResult(priority, preemptive);
        }
    }
}

