/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage3;

import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSubstitutionParamEntry;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameMatchRecognizeAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameMatchRecognizePrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNamePrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNamePrior;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryAgg;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryPrevious;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryPrior;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryResult;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameTableAccess;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameViewAgg;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenRepetitiveValueBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryAssignments;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StmtClassForgeableStmtFields
implements StmtClassForgeable {
    private final String className;
    private final CodegenPackageScope packageScope;
    private final boolean dataflowOperatorFields;

    public StmtClassForgeableStmtFields(String className, CodegenPackageScope packageScope) {
        this(className, packageScope, false);
    }

    public StmtClassForgeableStmtFields(String className, CodegenPackageScope packageScope, boolean dataflowOperatorFields) {
        this.className = className;
        this.packageScope = packageScope;
        this.dataflowOperatorFields = dataflowOperatorFields;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        List<CodegenTypedParam> members;
        if (!this.dataflowOperatorFields && !this.packageScope.hasAnyFields()) {
            return null;
        }
        List<MemberFieldPair> memberFields = this.getMembers();
        int maxMembersPerClass = Math.max(1, this.packageScope.getConfig().getInternalUseOnlyMaxMembersPerClass());
        List<CodegenInnerClass> innerClasses = Collections.emptyList();
        if (memberFields.size() <= maxMembersPerClass) {
            members = this.toMembers(memberFields);
        } else {
            List<List<MemberFieldPair>> assignments = CollectionUtil.subdivide(memberFields, maxMembersPerClass);
            innerClasses = new ArrayList(assignments.size());
            members = this.makeInnerClasses(assignments, innerClasses);
        }
        CodegenCtor ctor = new CodegenCtor(this.getClass(), includeDebugSymbols, Collections.emptyList());
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod initMethod = this.packageScope.getInitMethod();
        new CodegenRepetitiveValueBuilder<Map.Entry<CodegenField, CodegenExpression>>(this.packageScope.getFieldsUnshared().entrySet(), initMethod, classScope, this.getClass()).addParam(EPStatementInitServices.EPTYPE, EPStatementInitServices.REF.getRef()).setConsumer((entry, index, leaf) -> leaf.getBlock().assignRef(((CodegenField)entry.getKey()).getNameWithMember(), (CodegenExpression)entry.getValue())).build();
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(initMethod, "init", methods);
        if (this.packageScope.hasAssignableStatementFields()) {
            CodegenMethod assignMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(StatementAIFactoryAssignments.EPTYPE, "assignments").setStatic(true);
            CodegenMethod unassignMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).setStatic(true);
            StmtClassForgeableStmtFields.generateAssignAndUnassign(assignMethod, unassignMethod, this.packageScope.getFieldsNamed());
            CodegenStackGenerator.recursiveBuildStack(assignMethod, "assign", methods);
            CodegenStackGenerator.recursiveBuildStack(unassignMethod, "unassign", methods);
        }
        return new CodegenClass(CodegenClassType.STATEMENTFIELDS, StatementFields.EPTYPE, this.className, classScope, members, ctor, methods, innerClasses);
    }

    private List<CodegenTypedParam> makeInnerClasses(List<List<MemberFieldPair>> assignments, List<CodegenInnerClass> innerClasses) {
        int indexAssignment = 0;
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(assignments.size());
        for (List<MemberFieldPair> assignment : assignments) {
            String classNameAssignment = "A" + indexAssignment;
            String memberNameAssignment = "a" + indexAssignment;
            ArrayList<CodegenTypedParam> assignmentMembers = new ArrayList<CodegenTypedParam>(assignment.size());
            for (MemberFieldPair memberField : assignment) {
                assignmentMembers.add(memberField.member);
                memberField.field.setAssignmentMemberName(memberNameAssignment);
            }
            CodegenInnerClass innerClass = new CodegenInnerClass(classNameAssignment, null, assignmentMembers, new CodegenClassMethods());
            innerClasses.add(innerClass);
            CodegenTypedParam member = new CodegenTypedParam(innerClass.getClassName(), memberNameAssignment).setStatic(true).setInitializer(CodegenExpressionBuilder.newInstance(innerClass.getClassName(), new CodegenExpression[0]));
            members.add(member);
            ++indexAssignment;
        }
        return members;
    }

    private List<CodegenTypedParam> toMembers(List<MemberFieldPair> memberFields) {
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(memberFields.size());
        for (MemberFieldPair memberField : memberFields) {
            members.add(memberField.member);
        }
        return members;
    }

    private List<MemberFieldPair> getMembers() {
        ArrayList<MemberFieldPair> members = new ArrayList<MemberFieldPair>();
        this.generateNamedMembers(members);
        for (Map.Entry<CodegenField, CodegenExpression> entry : this.packageScope.getFieldsUnshared().entrySet()) {
            CodegenField field = entry.getKey();
            CodegenTypedParam member = new CodegenTypedParam(field.getType(), field.getName()).setStatic(true).setFinal(false);
            members.add(new MemberFieldPair(member, field));
        }
        this.generateSubstitutionParamMembers(members);
        return members;
    }

    private void generateSubstitutionParamMembers(List<MemberFieldPair> members) {
        List<CodegenSubstitutionParamEntry> numbered = this.packageScope.getSubstitutionParamsByNumber();
        LinkedHashMap<String, CodegenSubstitutionParamEntry> named = this.packageScope.getSubstitutionParamsByName();
        if (numbered.isEmpty() && named.isEmpty()) {
            return;
        }
        if (!numbered.isEmpty() && !named.isEmpty()) {
            throw new IllegalStateException("Both named and numbered substitution parameters are non-empty");
        }
        List<CodegenSubstitutionParamEntry> fields = !numbered.isEmpty() ? numbered : new ArrayList<CodegenSubstitutionParamEntry>(named.values());
        for (int i = 0; i < fields.size(); ++i) {
            CodegenField field = fields.get(i).getField();
            String name = field.getName();
            CodegenTypedParam member = new CodegenTypedParam(fields.get(i).getType(), name).setStatic(true).setFinal(false);
            members.add(new MemberFieldPair(member, field));
        }
    }

    private void generateNamedMembers(List<MemberFieldPair> fields) {
        for (Map.Entry<CodegenFieldName, CodegenField> entry : this.packageScope.getFieldsNamed().entrySet()) {
            CodegenTypedParam member = new CodegenTypedParam(entry.getValue().getType(), entry.getKey().getName()).setFinal(false).setStatic(true);
            fields.add(new MemberFieldPair(member, entry.getValue()));
        }
    }

    private static void generateAssignAndUnassign(CodegenMethod assign, CodegenMethod unassign, LinkedHashMap<CodegenFieldName, CodegenField> names) {
        for (Map.Entry<CodegenFieldName, CodegenField> entry : names.entrySet()) {
            CodegenFieldName subq;
            CodegenFieldName name = entry.getKey();
            CodegenField field = entry.getValue();
            if (name instanceof CodegenFieldNameAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getAggregationResultFuture", new CodegenExpression[0]), field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNamePrevious) {
                CodegenFieldNamePrevious previous = (CodegenFieldNamePrevious)name;
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getPreviousStrategies", new CodegenExpression[0]), CodegenExpressionBuilder.constant(previous.getStreamNumber())), field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNamePrior) {
                CodegenFieldNamePrior prior = (CodegenFieldNamePrior)name;
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getPriorStrategies", new CodegenExpression[0]), CodegenExpressionBuilder.constant(prior.getStreamNumber())), field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameViewAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.constantNull(), field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryResult) {
                subq = (CodegenFieldNameSubqueryResult)name;
                CodegenExpression subqueryLookupStrategy = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryLookup", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryResult)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(subqueryLookupStrategy, field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryPrior) {
                subq = (CodegenFieldNameSubqueryPrior)name;
                CodegenExpression prior = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryPrior", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryPrior)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(prior, field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryPrevious) {
                subq = (CodegenFieldNameSubqueryPrevious)name;
                CodegenExpression prev = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryPrevious", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryPrevious)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(prev, field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameSubqueryAgg) {
                subq = (CodegenFieldNameSubqueryAgg)name;
                CodegenExpression agg = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getSubqueryAggregation", CodegenExpressionBuilder.constant(((CodegenFieldNameSubqueryAgg)subq).getSubqueryNumber()));
                StmtClassForgeableStmtFields.generate(agg, field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameTableAccess) {
                CodegenFieldNameTableAccess tableAccess = (CodegenFieldNameTableAccess)name;
                CodegenExpression tableAccessLookupStrategy = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getTableAccess", CodegenExpressionBuilder.constant(tableAccess.getTableAccessNumber()));
                StmtClassForgeableStmtFields.generate(tableAccessLookupStrategy, field, assign, unassign, false);
                continue;
            }
            if (name instanceof CodegenFieldNameMatchRecognizePrevious) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("assignments"), "getRowRecogPreviousStrategy", new CodegenExpression[0]), field, assign, unassign, true);
                continue;
            }
            if (name instanceof CodegenFieldNameMatchRecognizeAgg) {
                StmtClassForgeableStmtFields.generate(CodegenExpressionBuilder.constantNull(), field, assign, unassign, true);
                continue;
            }
            throw new IllegalStateException("Unrecognized field " + entry.getKey());
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.FIELDS;
    }

    public static void makeSubstitutionSetter(CodegenPackageScope packageScope, CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass assignerSetterClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FAFQueryMethodAssignerSetter.EPTYPE);
        method.getBlock().methodReturn(assignerSetterClass);
        CodegenMethod assignMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), StmtClassForgeableStmtFields.class, classScope).addParam(StatementAIFactoryAssignments.EPTYPE, "assignments");
        assignerSetterClass.addMethod("assign", assignMethod);
        if (!packageScope.getFieldsNamed().isEmpty()) {
            assignMethod.getBlock().staticMethod(packageScope.getFieldsClassNameOptional(), "assign", CodegenExpressionBuilder.ref("assignments"));
        }
        CodegenMethod setValueMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), StmtClassForgeableStmtFields.class, classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "index").addParam(EPTypePremade.OBJECT.getEPType(), "value");
        assignerSetterClass.addMethod("setValue", setValueMethod);
        CodegenSubstitutionParamEntry.codegenSetterMethod(classScope, setValueMethod);
    }

    private static void generate(CodegenExpression init, CodegenField field, CodegenMethod assign, CodegenMethod unassign, boolean generateUnassign) {
        assign.getBlock().assignRef(field.getNameWithMember(), init);
        if (generateUnassign) {
            unassign.getBlock().assignRef(field.getNameWithMember(), CodegenExpressionBuilder.constantNull());
        }
    }

    private static final class MemberFieldPair {
        private final CodegenTypedParam member;
        private final CodegenField field;

        public MemberFieldPair(CodegenTypedParam member, CodegenField field) {
            this.member = member;
            this.field = field;
        }

        public CodegenTypedParam getMember() {
            return this.member;
        }

        public CodegenField getField() {
            return this.field;
        }
    }
}

