/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class SAIFFInitializeBuilder {
    private final Class originator;
    private final String refName;
    private final SAIFFInitializeSymbol symbols;
    private final CodegenClassScope classScope;
    private CodegenMethod method;
    private boolean closed;

    public SAIFFInitializeBuilder(EPTypeClass returnType, Class originator, String refName, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        this.originator = originator;
        this.refName = refName;
        this.symbols = symbols;
        this.classScope = classScope;
        this.method = parent.makeChild(returnType, originator, (CodegenScope)classScope);
        this.method.getBlock().declareVarNewInstance(returnType, refName);
    }

    public SAIFFInitializeBuilder(String returnType, Class originator, String refName, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        this.originator = originator;
        this.refName = refName;
        this.symbols = symbols;
        this.classScope = classScope;
        this.method = parent.makeChild(returnType, originator, (CodegenScope)classScope);
        this.method.getBlock().declareVar(returnType, refName, CodegenExpressionBuilder.newInstance(returnType, new CodegenExpression[0]));
    }

    public SAIFFInitializeBuilder eventtypesMayNull(String name, EventType[] eventTypes) {
        return this.setValue(name, eventTypes == null ? CodegenExpressionBuilder.constantNull() : EventTypeUtility.resolveTypeArrayCodegenMayNull(eventTypes, this.symbols.getAddInitSvc(this.method)));
    }

    public SAIFFInitializeBuilder eventtype(String name, EventType eventType) {
        return this.setValue(name, eventType == null ? CodegenExpressionBuilder.constantNull() : EventTypeUtility.resolveTypeCodegen(eventType, this.symbols.getAddInitSvc(this.method)));
    }

    public SAIFFInitializeBuilder eventtypes(String name, EventType[] types) {
        return this.setValue(name, types == null ? CodegenExpressionBuilder.constantNull() : EventTypeUtility.resolveTypeArrayCodegen(types, this.symbols.getAddInitSvc(this.method)));
    }

    public SAIFFInitializeBuilder exprnode(String name, ExprNode value) {
        return this.setValue(name, value == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(value.getForge(), this.method, this.getClass(), this.classScope));
    }

    public SAIFFInitializeBuilder constant(String name, Object value) {
        if (value instanceof CodegenExpression) {
            throw new IllegalArgumentException("Expected a non-expression value, received " + value);
        }
        return this.setValue(name, value == null ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.constant(value));
    }

    public SAIFFInitializeBuilder method(String name, Function<CodegenMethod, CodegenExpression> expressionFunc) {
        CodegenExpression expression = expressionFunc.apply(this.method);
        return this.setValue(name, expression == null ? CodegenExpressionBuilder.constantNull() : expression);
    }

    public SAIFFInitializeBuilder expression(String name, CodegenExpression expression) {
        return this.setValue(name, expression == null ? CodegenExpressionBuilder.constantNull() : expression);
    }

    public SAIFFInitializeBuilder forges(String name, ExprForge[] evaluatorForges) {
        return this.setValue(name, evaluatorForges == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluators(evaluatorForges, (CodegenMethodScope)this.method, this.originator, this.classScope));
    }

    public SAIFFInitializeBuilder manufacturer(String name, EventBeanManufacturerForge forge) {
        if (forge == null) {
            return this.setValue(name, CodegenExpressionBuilder.constantNull());
        }
        CodegenExpressionField manufacturer = this.classScope.addFieldUnshared(true, EventBeanManufacturer.EPTYPE, forge.make(this.method, this.classScope));
        return this.setValue(name, manufacturer);
    }

    public SAIFFInitializeBuilder map(String name, Map<String, ?> values) {
        return this.setValue(name, this.buildMap(values));
    }

    private CodegenExpression buildMap(Map<String, ?> map) {
        if (map == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (map.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyMap", new CodegenExpression[0]);
        }
        CodegenMethod child = this.method.makeChild(EPTypePremade.MAP.getEPType(), this.originator, (CodegenScope)this.classScope);
        if (map.size() == 1) {
            Map.Entry<String, ?> single = map.entrySet().iterator().next();
            CodegenExpression value = this.buildMapValue(single.getValue(), child, this.classScope);
            child.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, "singletonMap", CodegenExpressionBuilder.constant(single.getKey()), value));
        } else {
            child.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "map", CodegenExpressionBuilder.newInstance(EPTypePremade.LINKEDHASHMAP.getEPType(), CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(map.size()))));
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                CodegenExpression value = this.buildMapValue(entry.getValue(), child, this.classScope);
                child.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("map"), "put", CodegenExpressionBuilder.constant(entry.getKey()), value);
            }
            child.getBlock().methodReturn(CodegenExpressionBuilder.ref("map"));
        }
        return CodegenExpressionBuilder.localMethod(child, new CodegenExpression[0]);
    }

    private CodegenExpression buildMapValue(Object value, CodegenMethod method, CodegenClassScope classScope) {
        if (value instanceof Map) {
            return this.buildMap((Map)value);
        }
        if (value instanceof ExprNode) {
            return ExprNodeUtilityCodegen.codegenEvaluator(((ExprNode)value).getForge(), method, this.getClass(), classScope);
        }
        return CodegenExpressionBuilder.constant(value);
    }

    private SAIFFInitializeBuilder setValue(String name, CodegenExpression expression) {
        this.method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(this.refName), "set" + this.getBeanCap(name), expression);
        return this;
    }

    private String getBeanCap(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public CodegenExpression build() {
        return CodegenExpressionBuilder.localMethod(this.buildMethod(), new CodegenExpression[0]);
    }

    public CodegenMethod buildMethod() {
        if (this.closed) {
            throw new IllegalStateException("Builder already completed build");
        }
        this.closed = true;
        this.method.getBlock().methodReturn(CodegenExpressionBuilder.ref(this.refName));
        return this.method;
    }

    public CodegenMethod getMethod() {
        return this.method;
    }
}

