/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createclass;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.context.aifactory.core.StmtForgeMethodCreateSimpleBase;
import com.espertech.esper.common.internal.context.aifactory.core.StmtForgeMethodRegisterResult;
import com.espertech.esper.common.internal.context.aifactory.createclass.StatementAgentInstanceFactoryCreateClassForge;
import com.espertech.esper.common.internal.context.aifactory.createclass.StmtClassForgeableAIFactoryProviderCreateClass;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileResult;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.fabric.FabricCharge;

public class StmtForgeMethodCreateClass
extends StmtForgeMethodCreateSimpleBase {
    private final ClassProvidedPrecompileResult classProvidedPrecompileResult;
    private final String className;

    public StmtForgeMethodCreateClass(StatementBaseInfo base, ClassProvidedPrecompileResult classProvidedPrecompileResult, String className) {
        super(base);
        this.classProvidedPrecompileResult = classProvidedPrecompileResult;
        this.className = className;
    }

    @Override
    protected StmtForgeMethodRegisterResult register(StatementCompileTimeServices services) throws ExprValidationException {
        if (services.getClassProvidedCompileTimeResolver().resolveClass(this.className) != null) {
            throw new ExprValidationException("Class '" + this.className + "' has already been declared");
        }
        ClassProvided classProvided = new ClassProvided(this.classProvidedPrecompileResult.getBytes(), this.className);
        NameAccessModifier visibility = services.getModuleVisibilityRules().getAccessModifierInlinedClass(this.base, classProvided.getClassName());
        classProvided.setModuleName(this.base.getModuleName());
        classProvided.setVisibility(visibility);
        classProvided.loadClasses(services.getParentClassLoader());
        services.getClassProvidedCompileTimeRegistry().newClass(classProvided);
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        services.getStateMgmtSettingsProvider().inlinedClasses(fabricCharge, classProvided);
        return new StmtForgeMethodRegisterResult(this.className, fabricCharge);
    }

    @Override
    protected StmtClassForgeable aiFactoryForgable(String className, CodegenPackageScope packageScope, EventType statementEventType, String objectName) {
        StatementAgentInstanceFactoryCreateClassForge forge = new StatementAgentInstanceFactoryCreateClassForge(statementEventType, className);
        return new StmtClassForgeableAIFactoryProviderCreateClass(className, packageScope, forge);
    }
}

