/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.ontrigger.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.soda.StreamSelector;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementInformationalsUtil;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethod;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.compile.util.CallbackAttributionStream;
import com.espertech.esper.common.internal.compile.util.CallbackAttributionStreamPattern;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorFilterForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorNamedWindowForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorPatternForge;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.core.OnTriggerActivatorDesc;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.onset.OnTriggerSetPlan;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.onset.OnTriggerSetUtil;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.onsplit.OnSplitStreamUtil;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger.OnTriggerPlan;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger.OnTriggerWindowPlan;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger.OnTriggerWindowUtil;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryProvider;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.context.module.StatementInformationalsCompileTime;
import com.espertech.esper.common.internal.context.module.StatementProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAttributionKeyStream;
import com.espertech.esper.common.internal.epl.pattern.core.PatternContext;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperActivations;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StmtForgeMethodOnTrigger
implements StmtForgeMethod {
    private final StatementBaseInfo base;

    public StmtForgeMethodOnTrigger(StatementBaseInfo base) {
        this.base = base;
    }

    @Override
    public StmtForgeMethodResult make(String packageName, String classPostfix, StatementCompileTimeServices services) throws ExprValidationException {
        OnTriggerPlan onTriggerPlan;
        OnTriggerDesc desc;
        OnTriggerActivatorDesc activatorResult;
        String contextName = this.base.getStatementSpec().getRaw().getOptionalContextName();
        ArrayList<FilterSpecTracked> filterSpecCompileds = new ArrayList<FilterSpecTracked>(2);
        ArrayList<ScheduleHandleTracked> schedules = new ArrayList<ScheduleHandleTracked>(2);
        ArrayList<NamedWindowConsumerStreamSpec> namedWindowConsumers = new ArrayList<NamedWindowConsumerStreamSpec>(2);
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        SubSelectActivationDesc subSelectActivationDesc = SubSelectHelperActivations.createSubSelectActivation(false, filterSpecCompileds, namedWindowConsumers, this.base, services);
        Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation = subSelectActivationDesc.getSubselects();
        additionalForgeables.addAll(subSelectActivationDesc.getAdditionalForgeables());
        fabricCharge.add(subSelectActivationDesc.getFabricCharge());
        StreamSpecCompiled streamSpec = this.base.getStatementSpec().getStreamSpecs()[0];
        StreamSelector optionalStreamSelector = null;
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            activatorResult = this.activatorFilter(filterStreamSpec, services);
            filterSpecCompileds.add(new FilterSpecTracked(new CallbackAttributionStream(0), filterStreamSpec.getFilterSpecCompiled()));
        } else if (streamSpec instanceof PatternStreamSpecCompiled) {
            PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
            List<EvalForgeNode> forges = patternStreamSpec.getRoot().collectFactories();
            for (EvalForgeNode forge : forges) {
                forge.collectSelfFilterAndSchedule(factoryNodeId -> new CallbackAttributionStreamPattern(0, factoryNodeId.shortValue()), filterSpecCompileds, schedules);
            }
            activatorResult = this.activatorPattern(patternStreamSpec, services);
            services.getStateMgmtSettingsProvider().pattern(fabricCharge, new PatternAttributionKeyStream(0), patternStreamSpec, this.base.getStatementRawInfo());
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            activatorResult = this.activatorNamedWindow(namedSpec, services);
            namedWindowConsumers.add(namedSpec);
        } else {
            if (streamSpec instanceof TableQueryStreamSpec) {
                throw new ExprValidationException("Tables cannot be used in an on-action statement triggering stream");
            }
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, classPostfix);
        CodegenPackageScope packageScope = new CodegenPackageScope(packageName, statementFieldsClassName, services.isInstrumented(), services.getConfiguration().getCompiler().getByteCode());
        String aiFactoryProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementAIFactoryProvider.class, classPostfix);
        OnTriggerDesc onTriggerDesc = this.base.getStatementSpec().getRaw().getOnTriggerDesc();
        if (onTriggerDesc instanceof OnTriggerWindowDesc) {
            desc = (OnTriggerWindowDesc)onTriggerDesc;
            NamedWindowMetaData namedWindow = services.getNamedWindowCompileTimeResolver().resolve(((OnTriggerWindowDesc)desc).getWindowName());
            TableMetaData table = null;
            if (namedWindow == null && (table = services.getTableCompileTimeResolver().resolve(((OnTriggerWindowDesc)desc).getWindowName())) == null) {
                throw new ExprValidationException("A named window or table '" + ((OnTriggerWindowDesc)desc).getWindowName() + "' has not been declared");
            }
            OnTriggerWindowPlan planDesc = new OnTriggerWindowPlan((OnTriggerWindowDesc)desc, contextName, activatorResult, optionalStreamSelector, subselectActivation, streamSpec);
            onTriggerPlan = OnTriggerWindowUtil.handleContextFactoryOnTrigger(aiFactoryProviderClassName, packageScope, classPostfix, namedWindow, table, planDesc, this.base, services);
        } else if (onTriggerDesc instanceof OnTriggerSetDesc) {
            desc = (OnTriggerSetDesc)onTriggerDesc;
            OnTriggerSetPlan plan = OnTriggerSetUtil.handleSetVariable(aiFactoryProviderClassName, packageScope, classPostfix, activatorResult, streamSpec.getOptionalStreamName(), subselectActivation, (OnTriggerSetDesc)desc, this.base, services);
            onTriggerPlan = new OnTriggerPlan(plan.getForgeable(), plan.getForgeables(), plan.getSelectSubscriberDescriptor(), plan.getAdditionalForgeables(), plan.getFabricCharge());
        } else {
            desc = (OnTriggerSplitStreamDesc)onTriggerDesc;
            onTriggerPlan = OnSplitStreamUtil.handleSplitStream(aiFactoryProviderClassName, packageScope, classPostfix, (OnTriggerSplitStreamDesc)desc, streamSpec, activatorResult, subselectActivation, this.base, services);
        }
        additionalForgeables.addAll(onTriggerPlan.getAdditionalForgeables());
        fabricCharge.add(onTriggerPlan.getFabricCharge());
        ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>(2);
        for (StmtClassForgeableFactory additional : additionalForgeables) {
            forgeables.add(additional.make(packageScope, classPostfix));
        }
        forgeables.addAll(onTriggerPlan.getForgeables());
        forgeables.add(onTriggerPlan.getFactory());
        String statementProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementProvider.class, classPostfix);
        StatementInformationalsCompileTime informationals = StatementInformationalsUtil.getInformationals(this.base, filterSpecCompileds, schedules, namedWindowConsumers, true, onTriggerPlan.getSubscriberDescriptor(), packageScope, services);
        forgeables.add(new StmtClassForgeableStmtProvider(aiFactoryProviderClassName, statementProviderClassName, informationals, packageScope));
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope));
        return new StmtForgeMethodResult(forgeables, filterSpecCompileds, schedules, namedWindowConsumers, FilterSpecCompiled.makeExprNodeList(filterSpecCompileds, Collections.emptyList()), packageScope, fabricCharge);
    }

    private OnTriggerActivatorDesc activatorNamedWindow(NamedWindowConsumerStreamSpec namedSpec, StatementCompileTimeServices services) {
        NamedWindowMetaData namedWindow = namedSpec.getNamedWindow();
        String triggerEventTypeName = namedSpec.getNamedWindow().getEventType().getName();
        StreamTypeServiceImpl typesFilterValidation = new StreamTypeServiceImpl(namedWindow.getEventType(), namedSpec.getOptionalStreamName(), false);
        ExprNode filterSingle = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(namedSpec.getFilterExpressions());
        QueryGraphForge filterQueryGraph = EPLValidationUtil.validateFilterGetQueryGraphSafe(filterSingle, typesFilterValidation, this.base.getStatementRawInfo(), services);
        ViewableActivatorNamedWindowForge activator = new ViewableActivatorNamedWindowForge(namedSpec, namedWindow, filterSingle, filterQueryGraph, false, namedSpec.getOptPropertyEvaluator());
        EventType activatorResultEventType = namedWindow.getEventType();
        if (namedSpec.getOptPropertyEvaluator() != null) {
            activatorResultEventType = namedSpec.getOptPropertyEvaluator().getFragmentEventType();
        }
        return new OnTriggerActivatorDesc(activator, triggerEventTypeName, activatorResultEventType);
    }

    private OnTriggerActivatorDesc activatorFilter(FilterStreamSpecCompiled filterStreamSpec, StatementCompileTimeServices services) {
        String triggerEventTypeName = filterStreamSpec.getFilterSpecCompiled().getFilterForEventTypeName();
        ViewableActivatorFilterForge activator = new ViewableActivatorFilterForge(filterStreamSpec.getFilterSpecCompiled(), false, 0, false, -1);
        EventType activatorResultEventType = filterStreamSpec.getFilterSpecCompiled().getResultEventType();
        return new OnTriggerActivatorDesc(activator, triggerEventTypeName, activatorResultEventType);
    }

    private OnTriggerActivatorDesc activatorPattern(PatternStreamSpecCompiled patternStreamSpec, StatementCompileTimeServices services) {
        String triggerEventTypeName = patternStreamSpec.getOptionalStreamName();
        MapEventType patternType = ViewableActivatorPatternForge.makeRegisterPatternType(this.base.getModuleName(), 0, null, patternStreamSpec, services);
        PatternContext patternContext = new PatternContext(0, patternStreamSpec.getMatchedEventMapMeta(), false, -1, false);
        ViewableActivatorPatternForge activator = new ViewableActivatorPatternForge(patternType, patternStreamSpec, patternContext, false);
        return new OnTriggerActivatorDesc(activator, triggerEventTypeName, patternType);
    }
}

