/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeAction;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionDelete;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeMatched;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.core.OnTriggerActivatorDesc;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.ontrigger.OnTriggerPlanValidationResult;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorAttributionKeyStatement;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorDesc;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetSpec;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlanner;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperPlan;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactoryForge;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import com.espertech.esper.common.internal.util.UuidGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OnTriggerPlanValidator {
    public static final String INITIAL_VALUE_STREAM_NAME = "initial";

    public static OnTriggerPlanValidationResult validateOnTriggerPlan(EventType namedWindowOrTableType, OnTriggerWindowDesc onTriggerDesc, StreamSpecCompiled streamSpec, OnTriggerActivatorDesc activatorResult, Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        StreamTypeServiceImpl assignmentTypeService;
        String streamName;
        String zeroStreamAliasName = onTriggerDesc.getOptionalAsName();
        if (zeroStreamAliasName == null) {
            zeroStreamAliasName = "stream_0";
        }
        if ((streamName = streamSpec.getOptionalStreamName()) == null) {
            streamName = "stream_1";
        }
        String namedWindowTypeName = onTriggerDesc.getWindowName();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        String[] subselectStreamNames = new String[]{zeroStreamAliasName, streamSpec.getOptionalStreamName()};
        EventType[] subselectEventTypes = new EventType[]{namedWindowOrTableType, activatorResult.getActivatorResultEventType()};
        String[] subselectEventTypeNames = new String[]{namedWindowTypeName, activatorResult.getTriggerEventTypeName()};
        SubSelectHelperForgePlan subselectForgePlan = SubSelectHelperForgePlanner.planSubSelect(base, subselectActivation, subselectStreamNames, subselectEventTypes, subselectEventTypeNames, services);
        Map<ExprSubselectNode, SubSelectFactoryForge> subselectForges = subselectForgePlan.getSubselects();
        additionalForgeables.addAll(subselectForgePlan.getAdditionalForgeables());
        fabricCharge.add(subselectForgePlan.getFabricCharge());
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{namedWindowOrTableType, activatorResult.getActivatorResultEventType()}, new String[]{zeroStreamAliasName, streamName}, new boolean[]{false, true}, true, false);
        if (zeroStreamAliasName.equals(INITIAL_VALUE_STREAM_NAME) || streamName.equals(INITIAL_VALUE_STREAM_NAME)) {
            assignmentTypeService = typeService;
        } else {
            assignmentTypeService = new StreamTypeServiceImpl(new EventType[]{namedWindowOrTableType, activatorResult.getActivatorResultEventType(), namedWindowOrTableType}, new String[]{zeroStreamAliasName, streamName, INITIAL_VALUE_STREAM_NAME}, new boolean[]{false, true, true}, false, false);
            assignmentTypeService.setStreamZeroUnambigous(true);
        }
        if (onTriggerDesc instanceof OnTriggerWindowUpdateDesc) {
            OnTriggerWindowUpdateDesc updateDesc = (OnTriggerWindowUpdateDesc)onTriggerDesc;
            ExprValidationContext validationContext = new ExprValidationContextBuilder(assignmentTypeService, base.getStatementRawInfo(), services).withAllowBindingConsumption(true).build();
            for (OnTriggerSetAssignment assignment : updateDesc.getAssignments()) {
                ExprNodeUtilityValidate.validateAssignment(false, ExprNodeOrigin.UPDATEASSIGN, assignment, validationContext);
            }
        }
        if (onTriggerDesc instanceof OnTriggerMergeDesc) {
            OnTriggerMergeDesc mergeDesc = (OnTriggerMergeDesc)onTriggerDesc;
            OnTriggerPlanValidator.validateMergeDesc(mergeDesc, namedWindowOrTableType, zeroStreamAliasName, activatorResult.getActivatorResultEventType(), streamName, base.getStatementRawInfo(), services);
        }
        ExprNode validatedJoin = OnTriggerPlanValidator.validateJoinNamedWindow(ExprNodeOrigin.WHERE, base.getStatementSpec().getRaw().getWhereClause(), namedWindowOrTableType, zeroStreamAliasName, namedWindowTypeName, activatorResult.getActivatorResultEventType(), streamName, activatorResult.getTriggerEventTypeName(), null, base.getStatementRawInfo(), services);
        EPStatementStartMethodHelperValidate.validateNodes(base.getStatementSpec().getRaw(), typeService, null, base.getStatementRawInfo(), services);
        if (base.getStatementSpec().getSelectClauseCompiled().getSelectExprList().length == 0) {
            base.getStatementSpec().getSelectClauseCompiled().setSelectExprList(new SelectClauseElementWildcard());
        }
        ResultSetProcessorDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(ResultSetProcessorAttributionKeyStatement.INSTANCE, new ResultSetSpec(base.getStatementSpec()), typeService, null, new boolean[0], true, base.getContextPropertyRegistry(), false, true, base.getStatementRawInfo(), services);
        additionalForgeables.addAll(resultSetProcessorPrototype.getAdditionalForgeables());
        Map<ExprTableAccessNode, ExprTableEvalStrategyFactoryForge> tableAccessForges = ExprTableEvalHelperPlan.planTableAccess(base.getStatementSpec().getTableAccessNodes());
        return new OnTriggerPlanValidationResult(subselectForges, tableAccessForges, resultSetProcessorPrototype, validatedJoin, zeroStreamAliasName, additionalForgeables, fabricCharge);
    }

    protected static ExprNode validateJoinNamedWindow(ExprNodeOrigin exprNodeOrigin, ExprNode deleteJoinExpr, EventType namedWindowType, String namedWindowStreamName, String namedWindowName, EventType filteredType, String filterStreamName, String filteredTypeName, String optionalTableName, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        if (deleteJoinExpr == null) {
            return null;
        }
        LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        namesAndTypes.put(namedWindowStreamName, new Pair<EventType, String>(namedWindowType, namedWindowName));
        namesAndTypes.put(filterStreamName, new Pair<EventType, String>(filteredType, filteredTypeName));
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(namesAndTypes, false, false);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, statementRawInfo, compileTimeServices).withAllowBindingConsumption(true).build();
        return ExprNodeUtilityValidate.getValidatedSubtree(exprNodeOrigin, deleteJoinExpr, validationContext);
    }

    private static void validateMergeDesc(OnTriggerMergeDesc mergeDesc, EventType namedWindowType, String namedWindowName, EventType triggerStreamType, String triggerStreamName, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        String exprNodeErrorMessage = "Aggregation functions may not be used within an merge-clause";
        EventTypeMetadata dummyTypeNoPropertiesMeta = new EventTypeMetadata("merge_named_window_insert", statementRawInfo.getModuleName(), EventTypeTypeClass.STREAM, EventTypeApplicationType.MAP, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        MapEventType dummyTypeNoProperties = BaseNestableEventUtil.makeMapTypeCompileTime(dummyTypeNoPropertiesMeta, Collections.emptyMap(), null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        StreamTypeServiceImpl insertOnlyTypeSvc = new StreamTypeServiceImpl(new EventType[]{dummyTypeNoProperties, triggerStreamType}, new String[]{UuidGenerator.generate(), triggerStreamName}, new boolean[]{true, true}, true, false);
        StreamTypeServiceImpl twoStreamTypeSvc = new StreamTypeServiceImpl(new EventType[]{namedWindowType, triggerStreamType}, new String[]{namedWindowName, triggerStreamName}, new boolean[]{true, true}, true, false);
        for (OnTriggerMergeMatched matchedItem : mergeDesc.getItems()) {
            StreamTypeServiceImpl assignmentStreamTypeSvc;
            if (namedWindowName.equals(INITIAL_VALUE_STREAM_NAME) || triggerStreamName.equals(INITIAL_VALUE_STREAM_NAME)) {
                assignmentStreamTypeSvc = twoStreamTypeSvc;
            } else {
                assignmentStreamTypeSvc = new StreamTypeServiceImpl(new EventType[]{namedWindowType, triggerStreamType, namedWindowType}, new String[]{namedWindowName, triggerStreamName, INITIAL_VALUE_STREAM_NAME}, new boolean[]{true, true, true}, false, false);
                assignmentStreamTypeSvc.setStreamZeroUnambigous(true);
            }
            if (matchedItem.getOptionalMatchCond() != null) {
                StreamTypeServiceImpl matchValidStreams = matchedItem.isMatchedUnmatched() ? twoStreamTypeSvc : insertOnlyTypeSvc;
                matchedItem.setOptionalMatchCond(EPStatementStartMethodHelperValidate.validateExprNoAgg(ExprNodeOrigin.MERGEMATCHCOND, matchedItem.getOptionalMatchCond(), matchValidStreams, exprNodeErrorMessage, true, false, statementRawInfo, services));
                if (!matchedItem.isMatchedUnmatched()) {
                    EPStatementStartMethodHelperValidate.validateSubqueryExcludeOuterStream(matchedItem.getOptionalMatchCond());
                }
            }
            for (OnTriggerMergeAction item : matchedItem.getActions()) {
                if (item instanceof OnTriggerMergeActionDelete) {
                    OnTriggerMergeActionDelete delete = (OnTriggerMergeActionDelete)item;
                    if (delete.getOptionalWhereClause() == null) continue;
                    delete.setOptionalWhereClause(EPStatementStartMethodHelperValidate.validateExprNoAgg(ExprNodeOrigin.MERGEMATCHWHERE, delete.getOptionalWhereClause(), twoStreamTypeSvc, exprNodeErrorMessage, true, false, statementRawInfo, services));
                    continue;
                }
                if (item instanceof OnTriggerMergeActionUpdate) {
                    OnTriggerMergeActionUpdate update = (OnTriggerMergeActionUpdate)item;
                    if (update.getOptionalWhereClause() != null) {
                        update.setOptionalWhereClause(EPStatementStartMethodHelperValidate.validateExprNoAgg(ExprNodeOrigin.MERGEMATCHWHERE, update.getOptionalWhereClause(), twoStreamTypeSvc, exprNodeErrorMessage, true, false, statementRawInfo, services));
                    }
                    for (OnTriggerSetAssignment assignment : update.getAssignments()) {
                        ExprValidationContext validationContext = new ExprValidationContextBuilder(assignmentStreamTypeSvc, statementRawInfo, services).withAllowBindingConsumption(true).withAllowTableAggReset(true).build();
                        ExprNodeUtilityValidate.validateAssignment(false, ExprNodeOrigin.UPDATEASSIGN, assignment, validationContext);
                    }
                    continue;
                }
                if (item instanceof OnTriggerMergeActionInsert) {
                    OnTriggerMergeActionInsert insert = (OnTriggerMergeActionInsert)item;
                    StreamTypeService insertTypeSvc = OnTriggerPlanValidator.getInsertStreamService(insert.getOptionalStreamName(), namedWindowName, insertOnlyTypeSvc, twoStreamTypeSvc);
                    if (insert.getOptionalWhereClause() != null) {
                        insert.setOptionalWhereClause(EPStatementStartMethodHelperValidate.validateExprNoAgg(ExprNodeOrigin.MERGEMATCHWHERE, insert.getOptionalWhereClause(), insertTypeSvc, exprNodeErrorMessage, true, false, statementRawInfo, services));
                    }
                    List<SelectClauseElementCompiled> compiledSelect = OnTriggerPlanValidator.validateInsertSelect(insert.getSelectClause(), insertTypeSvc, insert.getColumns(), statementRawInfo, services);
                    insert.setSelectClauseCompiled(compiledSelect);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized merge item '" + item.getClass().getName() + "'");
            }
        }
        if (mergeDesc.getOptionalInsertNoMatch() != null) {
            StreamTypeService insertTypeSvc = OnTriggerPlanValidator.getInsertStreamService(mergeDesc.getOptionalInsertNoMatch().getOptionalStreamName(), namedWindowName, insertOnlyTypeSvc, twoStreamTypeSvc);
            List<SelectClauseElementCompiled> compiledSelect = OnTriggerPlanValidator.validateInsertSelect(mergeDesc.getOptionalInsertNoMatch().getSelectClause(), insertTypeSvc, mergeDesc.getOptionalInsertNoMatch().getColumns(), statementRawInfo, services);
            mergeDesc.getOptionalInsertNoMatch().setSelectClauseCompiled(compiledSelect);
        }
    }

    private static StreamTypeService getInsertStreamService(String optionalStreamName, String namedWindowName, StreamTypeService insertOnlyTypeSvc, StreamTypeServiceImpl twoStreamTypeSvc) {
        if (optionalStreamName == null || optionalStreamName.toLowerCase(Locale.ENGLISH).equals(namedWindowName.toLowerCase(Locale.ENGLISH))) {
            return insertOnlyTypeSvc;
        }
        return twoStreamTypeSvc;
    }

    private static List<SelectClauseElementCompiled> validateInsertSelect(List<SelectClauseElementRaw> selectClause, StreamTypeService insertTypeSvc, List<String> insertColumns, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        int colIndex = 0;
        ArrayList<SelectClauseElementCompiled> compiledSelect = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementRaw raw : selectClause) {
            if (raw instanceof SelectClauseStreamRawSpec) {
                SelectClauseStreamRawSpec rawStreamSpec = (SelectClauseStreamRawSpec)raw;
                Integer foundStreamNum = null;
                for (int s = 0; s < insertTypeSvc.getStreamNames().length; ++s) {
                    if (!rawStreamSpec.getStreamName().equals(insertTypeSvc.getStreamNames()[s])) continue;
                    foundStreamNum = s;
                    break;
                }
                if (foundStreamNum == null) {
                    throw new ExprValidationException("Stream by name '" + rawStreamSpec.getStreamName() + "' was not found");
                }
                SelectClauseStreamCompiledSpec streamSelectSpec = new SelectClauseStreamCompiledSpec(rawStreamSpec.getStreamName(), rawStreamSpec.getOptionalAsName());
                streamSelectSpec.setStreamNumber(foundStreamNum);
                compiledSelect.add(streamSelectSpec);
            } else if (raw instanceof SelectClauseExprRawSpec) {
                SelectClauseExprRawSpec exprSpec = (SelectClauseExprRawSpec)raw;
                ExprValidationContext validationContext = new ExprValidationContextBuilder(insertTypeSvc, statementRawInfo, services).withAllowBindingConsumption(true).build();
                ExprNode exprCompiled = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SELECT, exprSpec.getSelectExpression(), validationContext);
                String resultName = exprSpec.getOptionalAsName();
                if (resultName == null) {
                    resultName = insertColumns.size() > colIndex ? insertColumns.get(colIndex) : ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprCompiled);
                }
                compiledSelect.add(new SelectClauseExprCompiledSpec(exprCompiled, resultName, exprSpec.getOptionalAsName(), exprSpec.isEvents()));
                EPStatementStartMethodHelperValidate.validateNoAggregations(exprCompiled, "Expression in a merge-selection may not utilize aggregation functions");
            } else if (raw instanceof SelectClauseElementWildcard) {
                compiledSelect.add(new SelectClauseElementWildcard());
            } else {
                throw new IllegalStateException("Unknown select clause item:" + raw);
            }
            ++colIndex;
        }
        return compiledSelect;
    }
}

