/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.select;

import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultRuntime;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowDeployTimeResolver;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableDeployTimeResolver;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewFactoryForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeUniqueCandidate;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactoryForge;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public class StreamJoinAnalysisResultCompileTime {
    private final int numStreams;
    private boolean[] unidirectional;
    private boolean[] unidirectionalNonDriving;
    private boolean isPureSelfJoin;
    private boolean[] hasChildViews;
    private NamedWindowMetaData[] namedWindowsPerStream;
    private String[][][] uniqueKeys;
    private TableMetaData[] tablesPerStream;

    public StreamJoinAnalysisResultCompileTime(int numStreams) {
        this.numStreams = numStreams;
        this.isPureSelfJoin = false;
        this.unidirectional = new boolean[numStreams];
        this.unidirectionalNonDriving = new boolean[numStreams];
        this.hasChildViews = new boolean[numStreams];
        this.namedWindowsPerStream = new NamedWindowMetaData[numStreams];
        this.uniqueKeys = new String[numStreams][][];
        this.tablesPerStream = new TableMetaData[numStreams];
    }

    public void setUnidirectionalInd(int index) {
        this.unidirectional[index] = true;
    }

    public void setUnidirectionalNonDriving(int index) {
        this.unidirectionalNonDriving[index] = true;
    }

    public void setPureSelfJoin(boolean pureSelfJoin) {
        this.isPureSelfJoin = pureSelfJoin;
    }

    public void setHasChildViews(int index) {
        this.hasChildViews[index] = true;
    }

    public boolean[] getUnidirectionalInd() {
        return this.unidirectional;
    }

    public boolean[] getHasChildViews() {
        return this.hasChildViews;
    }

    public NamedWindowMetaData[] getNamedWindowsPerStream() {
        return this.namedWindowsPerStream;
    }

    public void setNamedWindowsPerStream(int streamNum, NamedWindowMetaData metadata) {
        this.namedWindowsPerStream[streamNum] = metadata;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public String[][][] getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setTablesForStream(int streamNum, TableMetaData metadata) {
        this.tablesPerStream[streamNum] = metadata;
    }

    public TableMetaData[] getTablesPerStream() {
        return this.tablesPerStream;
    }

    public void addUniquenessInfo(List<ViewFactoryForge>[] unmaterializedViewChain, Annotation[] annotations) {
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            Set<String> uniquenessProps = StreamJoinAnalysisResultCompileTime.getUniqueCandidateProperties(unmaterializedViewChain[i], annotations);
            if (uniquenessProps == null) continue;
            this.uniqueKeys[i] = new String[1][];
            this.uniqueKeys[i][0] = uniquenessProps.toArray(new String[uniquenessProps.size()]);
        }
    }

    public boolean isUnidirectional() {
        for (boolean ind : this.unidirectional) {
            if (!ind) continue;
            return true;
        }
        return false;
    }

    public boolean isUnidirectionalAll() {
        for (boolean ind : this.unidirectional) {
            if (ind) continue;
            return false;
        }
        return true;
    }

    public boolean isPureSelfJoin() {
        return this.isPureSelfJoin;
    }

    public int getUnidirectionalCount() {
        int count = 0;
        for (boolean ind : this.unidirectional) {
            count += ind ? 1 : 0;
        }
        return count;
    }

    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(StreamJoinAnalysisResultRuntime.EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVarNewInstance(StreamJoinAnalysisResultRuntime.EPTYPE, "ar").exprDotMethod(CodegenExpressionBuilder.ref("ar"), "setPureSelfJoin", CodegenExpressionBuilder.constant(this.isPureSelfJoin)).exprDotMethod(CodegenExpressionBuilder.ref("ar"), "setUnidirectional", CodegenExpressionBuilder.constant(this.unidirectional)).exprDotMethod(CodegenExpressionBuilder.ref("ar"), "setUnidirectionalNonDriving", CodegenExpressionBuilder.constant(this.unidirectionalNonDriving)).exprDotMethod(CodegenExpressionBuilder.ref("ar"), "setNamedWindows", this.makeNamedWindows(method, symbols)).exprDotMethod(CodegenExpressionBuilder.ref("ar"), "setTables", this.makeTables(method, symbols)).methodReturn(CodegenExpressionBuilder.ref("ar"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public boolean isVirtualDW(int stream) {
        return this.namedWindowsPerStream[stream] != null && this.namedWindowsPerStream[stream].isVirtualDataWindow();
    }

    private CodegenExpression makeTables(CodegenMethod method, SAIFFInitializeSymbol symbols) {
        CodegenExpression[] init = new CodegenExpression[this.tablesPerStream.length];
        for (int i = 0; i < init.length; ++i) {
            init[i] = this.tablesPerStream[i] == null ? CodegenExpressionBuilder.constantNull() : TableDeployTimeResolver.makeResolveTable(this.tablesPerStream[i], symbols.getAddInitSvc(method));
        }
        return CodegenExpressionBuilder.newArrayWithInit(Table.EPTYPE, init);
    }

    private CodegenExpression makeNamedWindows(CodegenMethod method, SAIFFInitializeSymbol symbols) {
        CodegenExpression[] init = new CodegenExpression[this.namedWindowsPerStream.length];
        for (int i = 0; i < init.length; ++i) {
            init[i] = this.namedWindowsPerStream[i] == null ? CodegenExpressionBuilder.constantNull() : NamedWindowDeployTimeResolver.makeResolveNamedWindow(this.namedWindowsPerStream[i], symbols.getAddInitSvc(method));
        }
        return CodegenExpressionBuilder.newArrayWithInit(NamedWindow.EPTYPE, init);
    }

    public static Set<String> getUniqueCandidateProperties(List<ViewFactoryForge> forges, Annotation[] annotations) {
        boolean disableUniqueImplicit;
        boolean bl = disableUniqueImplicit = HintEnum.DISABLE_UNIQUE_IMPLICIT_IDX.getHint(annotations) != null;
        if (forges == null || forges.isEmpty()) {
            return null;
        }
        if (forges.get(0) instanceof GroupByViewFactoryForge) {
            GroupByViewFactoryForge grouped = (GroupByViewFactoryForge)forges.get(0);
            ExprNode[] criteria = grouped.getCriteriaExpressions();
            Set<String> groupedCriteria = ExprNodeUtilityQuery.getPropertyNamesIfAllProps(criteria);
            if (groupedCriteria == null) {
                return null;
            }
            ViewFactoryForge inner = grouped.getGroupeds().get(0);
            if (inner instanceof DataWindowViewForgeUniqueCandidate && !disableUniqueImplicit) {
                DataWindowViewForgeUniqueCandidate uniqueFactory = (DataWindowViewForgeUniqueCandidate)((Object)inner);
                Set<String> uniqueCandidates = uniqueFactory.getUniquenessCandidatePropertyNames();
                if (uniqueCandidates != null) {
                    uniqueCandidates.addAll(groupedCriteria);
                }
                return uniqueCandidates;
            }
            return null;
        }
        if (forges.get(0) instanceof DataWindowViewForgeUniqueCandidate && !disableUniqueImplicit) {
            DataWindowViewForgeUniqueCandidate uniqueFactory = (DataWindowViewForgeUniqueCandidate)((Object)forges.get(0));
            return uniqueFactory.getUniquenessCandidatePropertyNames();
        }
        if (forges.get(0) instanceof VirtualDWViewFactoryForge) {
            VirtualDWViewFactoryForge vdw = (VirtualDWViewFactoryForge)forges.get(0);
            return vdw.getUniqueKeys();
        }
        return null;
    }
}

