/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.airegistry;

import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirementSubquery;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import java.util.Map;

public class AIRegistryRequirements {
    private final boolean[] priorFlagsPerStream;
    private final boolean[] previousFlagsPerStream;
    private final AIRegistryRequirementSubquery[] subqueries;
    private final int tableAccessCount;
    private final boolean isRowRecogWithPrevious;

    public static AIRegistryRequirements noRequirements() {
        return new AIRegistryRequirements(null, null, null, 0, false);
    }

    public AIRegistryRequirements(boolean[] priorFlagsPerStream, boolean[] previousFlagsPerStream, AIRegistryRequirementSubquery[] subqueries, int tableAccessCount, boolean isRowRecogWithPrevious) {
        this.priorFlagsPerStream = priorFlagsPerStream;
        this.previousFlagsPerStream = previousFlagsPerStream;
        this.subqueries = subqueries;
        this.tableAccessCount = tableAccessCount;
        this.isRowRecogWithPrevious = isRowRecogWithPrevious;
    }

    public boolean[] getPriorFlagsPerStream() {
        return this.priorFlagsPerStream;
    }

    public boolean[] getPreviousFlagsPerStream() {
        return this.previousFlagsPerStream;
    }

    public AIRegistryRequirementSubquery[] getSubqueries() {
        return this.subqueries;
    }

    public int getTableAccessCount() {
        return this.tableAccessCount;
    }

    public boolean isRowRecogWithPrevious() {
        return this.isRowRecogWithPrevious;
    }

    public static AIRegistryRequirementSubquery[] getSubqueryRequirements(Map<Integer, SubSelectFactory> subselects) {
        if (subselects == null || subselects.isEmpty()) {
            return null;
        }
        AIRegistryRequirementSubquery[] subqueries = new AIRegistryRequirementSubquery[subselects.size()];
        for (Map.Entry<Integer, SubSelectFactory> entry : subselects.entrySet()) {
            subqueries[entry.getKey().intValue()] = entry.getValue().getRegistryRequirements();
        }
        return subqueries;
    }
}

