/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.category;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.context.ContextPartitionIdentifier;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierCategory;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryFactoryMultiPerm;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerCategoryImpl;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerDetailCategory;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerDetailCategoryItem;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactoryBase;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import java.util.Map;

public class ContextControllerCategoryFactory
extends ContextControllerFactoryBase {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ContextControllerCategoryFactory.class);
    private String contextName;
    private ContextControllerDetailCategory categorySpec;

    public ContextControllerDetailCategory getCategorySpec() {
        return this.categorySpec;
    }

    public void setCategorySpec(ContextControllerDetailCategory categorySpec) {
        this.categorySpec = categorySpec;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    @Override
    public ContextController create(ContextManagerRealization contextManagerRealization) {
        return new ContextControllerCategoryImpl(contextManagerRealization, this);
    }

    @Override
    public FilterValueSetParam[][] populateFilterAddendum(FilterSpecActivatable filterSpec, boolean forStatement, int nestingLevel, Object partitionKey, ContextControllerStatementDesc optionalStatementDesc, Map<Integer, ContextControllerStatementDesc> statements, AgentInstanceContext agentInstanceContextStatement) {
        if (!forStatement && !EventTypeUtility.isTypeOrSubTypeOf(filterSpec.getFilterForEventType(), this.categorySpec.getFilterSpecActivatable().getFilterForEventType())) {
            return null;
        }
        int categoryNum = (Integer)partitionKey;
        ContextControllerDetailCategoryItem item = this.categorySpec.getItems()[categoryNum];
        FilterValueSetParam[][] filters = item.getFilterPlan().evaluateValueSet(null, agentInstanceContextStatement, agentInstanceContextStatement.getStatementContextFilterEvalEnv());
        if (filters == null) {
            throw new EPException("Category context '" + this.contextName + "' for category '" + item.getName() + "' has evaluated to a condition that cannot become true");
        }
        return filters;
    }

    @Override
    public void populateContextProperties(Map<String, Object> props, Object allPartitionKey) {
        ContextControllerDetailCategoryItem item = this.categorySpec.getItems()[(Integer)allPartitionKey];
        props.put("label", item.getName());
    }

    @Override
    public StatementAIResourceRegistry allocateAgentInstanceResourceRegistry(AIRegistryRequirements registryRequirements) {
        return AIRegistryUtil.allocateRegistries(registryRequirements, AIRegistryFactoryMultiPerm.INSTANCE);
    }

    @Override
    public ContextPartitionIdentifier getContextPartitionIdentifier(Object partitionKey) {
        int categoryNum = (Integer)partitionKey;
        ContextControllerDetailCategoryItem item = this.categorySpec.getItems()[categoryNum];
        return new ContextPartitionIdentifierCategory(item.getName());
    }
}

