/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;

public class ContextControllerFactoryEnv {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ContextControllerFactoryEnv.class);
    private final String outermostContextName;
    private final String contextName;
    private final int nestingLevel;
    private final int numNestingLevels;

    public ContextControllerFactoryEnv(String outermostContextName, String contextName, int nestingLevel, int numNestingLevels) {
        this.outermostContextName = outermostContextName;
        this.contextName = contextName;
        this.nestingLevel = nestingLevel;
        this.numNestingLevels = numNestingLevels;
    }

    public String getOutermostContextName() {
        return this.outermostContextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public int getNumNestingLevels() {
        return this.numNestingLevels;
    }

    public CodegenExpression toExpression() {
        return CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.constant(this.outermostContextName), CodegenExpressionBuilder.constant(this.contextName), CodegenExpressionBuilder.constant(this.nestingLevel), CodegenExpressionBuilder.constant(this.numNestingLevels));
    }

    public boolean isLeaf() {
        return this.nestingLevel == this.numNestingLevels;
    }

    public boolean isRoot() {
        return this.numNestingLevels == 1 || this.nestingLevel == 1;
    }
}

