/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerDetailHashItem;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHash;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashFactory;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashFilterEntry;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvc;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;

public class ContextControllerHashImpl
extends ContextControllerHash {
    private final ContextControllerHashSvc hashSvc;

    public ContextControllerHashImpl(ContextControllerHashFactory factory, ContextManagerRealization realization) {
        super(realization, factory);
        this.hashSvc = ContextControllerHashUtil.makeService(factory, realization);
    }

    @Override
    public void activate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern) {
        this.hashSvc.mgmtCreate(path, parentPartitionKeys);
        if (this.factory.getHashSpec().isPreallocate()) {
            int[] subpathOrCPIds = this.activateByPreallocate(path, parentPartitionKeys, optionalTriggeringEvent);
            this.hashSvc.mgmtSetSubpathOrCPIdsWhenPreallocate(path, subpathOrCPIds);
            return;
        }
        ContextControllerDetailHashItem[] hashItems = this.factory.getHashSpec().getItems();
        ContextControllerFilterEntry[] filterEntries = new ContextControllerFilterEntry[hashItems.length];
        for (int i = 0; i < hashItems.length; ++i) {
            boolean match;
            ContextControllerDetailHashItem item = hashItems[i];
            filterEntries[i] = new ContextControllerHashFilterEntry(this, path, item, parentPartitionKeys);
            if (optionalTriggeringEvent == null || !(match = AgentInstanceUtil.evaluateFilterForStatement(optionalTriggeringEvent, this.realization.getAgentInstanceContextCreate(), filterEntries[i].getFilterHandle()))) continue;
            this.matchFound(item, optionalTriggeringEvent, path);
        }
        this.hashSvc.mgmtSetFilters(path, filterEntries);
    }

    @Override
    public void deactivate(IntSeqKey path, boolean terminateChildContexts) {
        if (this.factory.getHashSpec().isPreallocate() && terminateChildContexts) {
            int[] subpathOrCPIds = this.hashSvc.mgmtGetSubpathOrCPIdsWhenPreallocate(path);
            for (int i = 0; i < this.factory.getHashSpec().getGranularity(); ++i) {
                this.realization.contextPartitionTerminate(path, subpathOrCPIds[i], this, null, false, null);
            }
            return;
        }
        ContextControllerFilterEntry[] filters = this.hashSvc.mgmtGetFilters(path);
        if (filters != null) {
            for (ContextControllerFilterEntry callback : filters) {
                ((ContextControllerHashFilterEntry)callback).destroy();
            }
        }
        Collection<Integer> subpathOrCPIds = this.hashSvc.deactivate(path);
        for (int id : subpathOrCPIds) {
            this.realization.contextPartitionTerminate(path, id, this, null, false, null);
        }
    }

    public void matchFound(ContextControllerDetailHashItem item, EventBean theEvent, IntSeqKey controllerPath) {
        int value = (Integer)item.getLookupable().getEval().eval(theEvent, this.realization.getAgentInstanceContextCreate());
        if (this.hashSvc.hashHasSeenPartition(controllerPath, value)) {
            return;
        }
        Object[] parentPartitionKeys = this.hashSvc.mgmtGetParentPartitionKeys(controllerPath);
        ContextPartitionInstantiationResult result = this.realization.contextPartitionInstantiate(controllerPath, value, this, theEvent, null, parentPartitionKeys, value);
        int subpathIdOrCPId = result.getSubpathOrCPId();
        this.hashSvc.hashAddPartition(controllerPath, value, subpathIdOrCPId);
        long filterVersion = this.realization.getAgentInstanceContextCreate().getFilterService().getFiltersVersion();
        this.realization.getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filterVersion);
    }

    @Override
    protected void visitPartitions(IntSeqKey controllerPath, BiConsumer<Integer, Integer> hashAndCPId) {
        this.hashSvc.hashVisit(controllerPath, hashAndCPId);
    }

    @Override
    protected int getSubpathOrCPId(IntSeqKey path, int hash) {
        return this.hashSvc.hashGetSubpathOrCPId(path, hash);
    }

    @Override
    public void destroy() {
        this.hashSvc.destroy();
    }

    @Override
    public void transfer(IntSeqKey path, boolean transferChildContexts, AgentInstanceTransferServices xfer) {
        if (!this.factory.getHashSpec().isPreallocate()) {
            ContextControllerFilterEntry[] filterEntries = this.hashSvc.mgmtGetFilters(path);
            ContextControllerDetailHashItem[] hashItems = this.factory.getHashSpec().getItems();
            for (int i = 0; i < hashItems.length; ++i) {
                filterEntries[i].transfer(hashItems[i].getFilterSpecActivatable(), xfer);
            }
        }
        if (!transferChildContexts) {
            return;
        }
        this.visitPartitions(path, (hash, subpathOrCPId) -> this.realization.transferRecursive(path, (int)subpathOrCPId, this, xfer));
    }
}

