/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerCondition;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermPartitionKey;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvc;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public class ContextControllerInitTermSvcLevelAny
implements ContextControllerInitTermSvc {
    private Map<IntSeqKey, NestedEntry> mgmt = new HashMap<IntSeqKey, NestedEntry>();
    private Map<IntSeqKey, ContextControllerInitTermSvcEntry> endConditions = new HashMap<IntSeqKey, ContextControllerInitTermSvcEntry>();

    @Override
    public void mgmtCreate(IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        NestedEntry existing = this.mgmt.putIfAbsent(controllerPath, new NestedEntry(0, null, parentPartitionKeys));
        if (existing != null) {
            throw new IllegalStateException("Unexpected existing entry for path");
        }
    }

    @Override
    public Object[] mgmtGetParentPartitionKeys(IntSeqKey controllerPath) {
        NestedEntry entry = this.mgmt.get(controllerPath);
        return entry == null ? null : entry.parentPartitionKeys;
    }

    @Override
    public ContextControllerConditionNonHA mgmtDelete(IntSeqKey controllerPath) {
        NestedEntry existing = this.mgmt.remove(controllerPath);
        return existing == null ? null : existing.startCondition;
    }

    @Override
    public ContextControllerConditionNonHA mgmtUpdClearStartCondition(IntSeqKey controllerPath) {
        NestedEntry existing = this.mgmt.get(controllerPath);
        ContextControllerConditionNonHA tmp = null;
        if (existing != null) {
            tmp = existing.startCondition;
            existing.startCondition = null;
        }
        return tmp;
    }

    @Override
    public void mgmtUpdSetStartCondition(IntSeqKey controllerPath, ContextControllerConditionNonHA startCondition) {
        NestedEntry existing = this.mgmt.get(controllerPath);
        if (existing != null) {
            existing.startCondition = startCondition;
        }
    }

    @Override
    public int mgmtUpdIncSubpath(IntSeqKey controllerPath) {
        NestedEntry existing = this.mgmt.get(controllerPath);
        if (existing == null) {
            throw new IllegalStateException("Unexpected no-entry-found for path");
        }
        return existing.currentSubpath++;
    }

    @Override
    public ContextControllerCondition mgmtGetStartCondition(IntSeqKey controllerPath) {
        NestedEntry existing = this.mgmt.get(controllerPath);
        return existing == null ? null : existing.startCondition;
    }

    @Override
    public void endCreate(IntSeqKey endConditionPath, int subpathIdOrCPId, ContextControllerConditionNonHA endCondition, ContextControllerInitTermPartitionKey partitionKey) {
        this.endConditions.put(endConditionPath, new ContextControllerInitTermSvcEntry(subpathIdOrCPId, endCondition, partitionKey));
    }

    @Override
    public ContextControllerInitTermSvcEntry endDelete(IntSeqKey conditionPath) {
        return this.endConditions.remove(conditionPath);
    }

    @Override
    public Collection<ContextControllerInitTermSvcEntry> endDeleteByParentPath(IntSeqKey controllerPath) {
        ArrayList<ContextControllerInitTermSvcEntry> entries = new ArrayList<ContextControllerInitTermSvcEntry>();
        Iterator<Map.Entry<IntSeqKey, ContextControllerInitTermSvcEntry>> it = this.endConditions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IntSeqKey, ContextControllerInitTermSvcEntry> entry = it.next();
            if (!controllerPath.isParentTo(entry.getKey())) continue;
            entries.add(entry.getValue());
            it.remove();
        }
        return entries;
    }

    @Override
    public void endVisit(IntSeqKey controllerPath, BiConsumer<ContextControllerInitTermPartitionKey, Integer> partKeyAndCPId) {
        for (Map.Entry<IntSeqKey, ContextControllerInitTermSvcEntry> entry : this.endConditions.entrySet()) {
            if (!controllerPath.isParentTo(entry.getKey())) continue;
            partKeyAndCPId.accept(entry.getValue().getPartitionKey(), entry.getValue().getSubpathIdOrCPId());
        }
    }

    @Override
    public void endVisitConditions(IntSeqKey controllerPath, BiConsumer<ContextControllerConditionNonHA, Integer> partKeyAndCPId) {
        for (Map.Entry<IntSeqKey, ContextControllerInitTermSvcEntry> entry : this.endConditions.entrySet()) {
            if (!controllerPath.isParentTo(entry.getKey())) continue;
            partKeyAndCPId.accept(entry.getValue().getTerminationCondition(), entry.getValue().getSubpathIdOrCPId());
        }
    }

    @Override
    public void destroy() {
        this.mgmt = null;
        this.endConditions = null;
    }

    private static class NestedEntry {
        int currentSubpath;
        ContextControllerConditionNonHA startCondition;
        Object[] parentPartitionKeys;

        NestedEntry(int currentSubpath, ContextControllerConditionNonHA startCondition, Object[] parentPartitionKeys) {
            this.currentSubpath = currentSubpath;
            this.startCondition = startCondition;
            this.parentPartitionKeys = parentPartitionKeys;
        }
    }
}

