/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedCompositeKey;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvc;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvcEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ContextControllerKeyedSvcLevelAny
implements ContextControllerKeyedSvc {
    private final Map<IntSeqKey, MgmtInfo> mgmt = new HashMap<IntSeqKey, MgmtInfo>();
    private final Map<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry> keys = new HashMap<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry>();

    @Override
    public void mgmtCreate(IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        this.mgmt.put(controllerPath, new MgmtInfo(0, null, parentPartitionKeys));
    }

    @Override
    public void mgmtSetFilters(IntSeqKey controllerPath, ContextControllerFilterEntry[] filterEntries) {
        MgmtInfo entry = this.mgmt.get(controllerPath);
        entry.setFilterEntries(filterEntries);
    }

    @Override
    public Object[] mgmtGetPartitionKeys(IntSeqKey controllerPath) {
        return this.mgmt.get(controllerPath).parentPartitionKeys;
    }

    @Override
    public int mgmtGetIncSubpath(IntSeqKey controllerPath) {
        MgmtInfo entry = this.mgmt.get(controllerPath);
        int subpathId = entry.currentSubpathId;
        entry.currentSubpathId++;
        return subpathId;
    }

    @Override
    public ContextControllerFilterEntry[] mgmtGetFilters(IntSeqKey controllerPath) {
        return this.mgmt.get(controllerPath).filterEntries;
    }

    @Override
    public boolean keyHasSeen(IntSeqKey controllerPath, Object key) {
        return this.keys.containsKey(new ContextControllerKeyedCompositeKey(controllerPath, key));
    }

    @Override
    public void keyAdd(IntSeqKey controllerPath, Object key, int subpathIdOrCPId, ContextControllerConditionNonHA terminationCondition) {
        this.keys.put(new ContextControllerKeyedCompositeKey(controllerPath, key), new ContextControllerKeyedSvcEntry(subpathIdOrCPId, terminationCondition));
    }

    @Override
    public ContextControllerKeyedSvcEntry keyRemove(IntSeqKey controllerPath, Object key) {
        return this.keys.remove(new ContextControllerKeyedCompositeKey(controllerPath, key));
    }

    @Override
    public List<ContextControllerConditionNonHA> keyGetTermConditions(IntSeqKey controllerPath) {
        ArrayList<ContextControllerConditionNonHA> conditions = new ArrayList<ContextControllerConditionNonHA>();
        for (Map.Entry<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            if (!controllerPath.equals(entry.getKey().getPath())) continue;
            conditions.add(entry.getValue().getTerminationCondition());
        }
        return conditions;
    }

    @Override
    public void keyVisit(IntSeqKey controllerPath, BiConsumer<Object, Integer> keyAndSubpathOrCPId) {
        for (Map.Entry<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            if (!controllerPath.equals(entry.getKey().getPath())) continue;
            keyAndSubpathOrCPId.accept(entry.getKey().getKey(), entry.getValue().getSubpathOrCPId());
        }
    }

    @Override
    public void keyVisitEntry(IntSeqKey controllerPath, Consumer<ContextControllerKeyedSvcEntry> consumer) {
        for (Map.Entry<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            if (!controllerPath.equals(entry.getKey().getPath())) continue;
            consumer.accept(entry.getValue());
        }
    }

    @Override
    public int keyGetSubpathOrCPId(IntSeqKey controllerPath, Object key) {
        ContextControllerKeyedSvcEntry entry = this.keys.get(new ContextControllerKeyedCompositeKey(controllerPath, key));
        return entry == null ? -1 : entry.getSubpathOrCPId();
    }

    @Override
    public Collection<Integer> deactivate(IntSeqKey controllerPath) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Iterator<Map.Entry<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry>> iterator = this.keys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ContextControllerKeyedCompositeKey, ContextControllerKeyedSvcEntry> entry = iterator.next();
            if (!controllerPath.equals(entry.getKey().getPath())) continue;
            ids.add(entry.getValue().getSubpathOrCPId());
            iterator.remove();
        }
        return ids;
    }

    @Override
    public void destroy() {
        this.mgmt.clear();
        this.keys.clear();
    }

    private static class MgmtInfo {
        private int currentSubpathId;
        private ContextControllerFilterEntry[] filterEntries;
        private Object[] parentPartitionKeys;

        public MgmtInfo(int currentSubpathId, ContextControllerFilterEntry[] filterEntries, Object[] parentPartitionKeys) {
            this.currentSubpathId = currentSubpathId;
            this.filterEntries = filterEntries;
            this.parentPartitionKeys = parentPartitionKeys;
        }

        public int getCurrentSubpathId() {
            return this.currentSubpathId;
        }

        public ContextControllerFilterEntry[] getFilterEntries() {
            return this.filterEntries;
        }

        public Object[] getParentPartitionKeys() {
            return this.parentPartitionKeys;
        }

        public void setFilterEntries(ContextControllerFilterEntry[] filterEntries) {
            this.filterEntries = filterEntries;
        }
    }
}

