/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionCollection;
import com.espertech.esper.common.client.context.ContextPartitionIdentifier;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierNested;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionStateListener;
import com.espertech.esper.common.client.context.ContextStateEventContextActivated;
import com.espertech.esper.common.client.context.ContextStateEventContextDeactivated;
import com.espertech.esper.common.client.context.ContextStateEventContextStatementAdded;
import com.espertech.esper.common.client.context.ContextStateEventContextStatementRemoved;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.util.SafeIterator;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryFactoryMap;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.context.controller.core.ContextDefinition;
import com.espertech.esper.common.internal.context.cpidsvc.ContextPartitionIdService;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextManagerUtil;
import com.espertech.esper.common.internal.context.mgr.ContextStateEventUtil;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceArrayIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceArraySafeIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceFilterProxy;
import com.espertech.esper.common.internal.context.util.AgentInstanceFilterProxyImpl;
import com.espertech.esper.common.internal.context.util.ContextAgentInstanceInfo;
import com.espertech.esper.common.internal.context.util.ContextIteratorHandler;
import com.espertech.esper.common.internal.context.util.ContextRuntimeDescriptor;
import com.espertech.esper.common.internal.context.util.StatementCPCacheService;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContextManagerResident
implements ContextManager,
ContextIteratorHandler {
    private final ContextDefinition contextDefinition;
    private final Map<Integer, ContextControllerStatementDesc> statements = new LinkedHashMap<Integer, ContextControllerStatementDesc>();
    private ContextRuntimeDescriptor contextRuntimeDescriptor;
    protected CopyOnWriteArrayList<ContextPartitionStateListener> listenersLazy;
    private StatementContext statementContextCreate;
    private DataInputOutputSerde[] contextPartitionKeySerdes;
    private ContextPartitionIdService contextPartitionIdService;

    public ContextManagerResident(String deploymentId, ContextDefinition contextDefinition) {
        this.contextDefinition = contextDefinition;
        this.contextRuntimeDescriptor = new ContextRuntimeDescriptor(contextDefinition.getContextName(), deploymentId, this);
    }

    @Override
    public void setStatementContext(StatementContext statementContext) {
        this.statementContextCreate = statementContext;
        this.contextPartitionKeySerdes = this.statementContextCreate.getContextServiceFactory().getContextPartitionKeyBindings(this.contextDefinition);
        this.contextPartitionIdService = this.statementContextCreate.getContextServiceFactory().getContextPartitionIdService(this.statementContextCreate, this.contextPartitionKeySerdes, this.contextDefinition.getPartitionIdSvcStateMgmtSettings());
    }

    @Override
    public void addStatement(ContextControllerStatementDesc statement, boolean recovery) {
        StatementContext statementContextOfStatement = statement.getLightweight().getStatementContext();
        this.statements.put(statementContextOfStatement.getStatementId(), statement);
        ContextStateEventUtil.dispatchPartition(this.listenersLazy, () -> new ContextStateEventContextStatementAdded(this.statementContextCreate.getRuntimeURI(), this.contextRuntimeDescriptor.getContextDeploymentId(), this.contextDefinition.getContextName(), statementContextOfStatement.getDeploymentId(), statementContextOfStatement.getStatementName()), ContextPartitionStateListener::onContextStatementAdded);
        if (recovery) {
            if (statement.getLightweight().getStatementInformationals().getStatementType() == StatementType.CREATE_VARIABLE) {
                this.getRealization().activateCreateVariableStatement(statement);
            }
            return;
        }
        if (this.statements.size() == 1) {
            this.getRealization().startContext();
            ContextStateEventUtil.dispatchPartition(this.listenersLazy, () -> new ContextStateEventContextActivated(this.statementContextCreate.getRuntimeURI(), this.contextRuntimeDescriptor.getContextDeploymentId(), this.contextDefinition.getContextName()), ContextPartitionStateListener::onContextActivated);
        } else {
            this.getRealization().startLateStatement(statement);
        }
    }

    @Override
    public void stopStatement(int statementId, String statementName, String statementDeploymentId) {
        if (!this.statements.containsKey(statementId)) {
            return;
        }
        this.removeStatement(statementId);
        ContextStateEventUtil.dispatchPartition(this.listenersLazy, () -> new ContextStateEventContextStatementRemoved(this.statementContextCreate.getRuntimeURI(), this.contextRuntimeDescriptor.getContextDeploymentId(), this.contextRuntimeDescriptor.getContextName(), statementDeploymentId, statementName), ContextPartitionStateListener::onContextStatementRemoved);
        if (this.statements.isEmpty()) {
            this.getRealization().stopContext();
            this.contextPartitionIdService.clear();
            ContextStateEventUtil.dispatchPartition(this.listenersLazy, () -> new ContextStateEventContextDeactivated(this.statementContextCreate.getRuntimeURI(), this.contextRuntimeDescriptor.getContextDeploymentId(), this.contextRuntimeDescriptor.getContextName()), ContextPartitionStateListener::onContextDeactivated);
        }
    }

    @Override
    public int countStatements(Function<StatementContext, Boolean> filter) {
        int count = 0;
        for (Map.Entry<Integer, ContextControllerStatementDesc> entry : this.statements.entrySet()) {
            if (!filter.apply(entry.getValue().getLightweight().getStatementContext()).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public ContextDefinition getContextDefinition() {
        return this.contextDefinition;
    }

    @Override
    public ContextManagerRealization getRealization() {
        StatementResourceHolder statementResourceHolder = this.statementContextCreate.getStatementCPCacheService().makeOrGetEntryCanNull(-1, this.statementContextCreate);
        return statementResourceHolder.getContextManagerRealization();
    }

    @Override
    public void destroyContext() {
        if (!this.statements.isEmpty()) {
            throw new IllegalStateException("Cannot invoke destroy with statements still attached");
        }
        if (this.contextPartitionIdService == null) {
            return;
        }
        this.getRealization().safeDestroyContext();
        this.contextPartitionIdService.destroy();
        this.contextPartitionIdService = null;
    }

    @Override
    public ContextManagerRealization allocateNewRealization(AgentInstanceContext agentInstanceContext) {
        return new ContextManagerRealization(this, agentInstanceContext);
    }

    private void removeStatement(int statementId) {
        ContextControllerStatementDesc statementDesc = this.statements.get(statementId);
        if (statementDesc == null) {
            return;
        }
        this.getRealization().removeStatement(statementDesc);
        this.statements.remove(statementId);
    }

    @Override
    public Map<Integer, ContextControllerStatementDesc> getStatements() {
        return this.statements;
    }

    public StatementContext getStatementContextCreate() {
        return this.statementContextCreate;
    }

    @Override
    public ContextAgentInstanceInfo getContextAgentInstanceInfo(StatementContext statementContextOfStatement, int agentInstanceId) {
        Object[] partitionKeys = this.contextPartitionIdService.getPartitionKeys(agentInstanceId);
        if (partitionKeys == null) {
            return null;
        }
        ContextControllerStatementDesc statement = this.statements.get(statementContextOfStatement.getStatementId());
        MappedEventBean props = ContextManagerUtil.buildContextProperties(agentInstanceId, partitionKeys, this.contextDefinition, this.statementContextCreate);
        AgentInstanceFilterProxy proxy = this.computeFilterAddendum(statement, partitionKeys);
        return new ContextAgentInstanceInfo(props, proxy);
    }

    public AgentInstanceFilterProxy computeFilterAddendum(ContextControllerStatementDesc statement, Object[] contextPartitionKeys) {
        Supplier<IdentityHashMap<FilterSpecActivatable, FilterValueSetParam[][]>> generator = () -> ContextManagerUtil.computeAddendumForStatement(statement, this.statements, this.contextDefinition.getControllerFactories(), contextPartitionKeys, this.getRealization().getAgentInstanceContextCreate());
        return new AgentInstanceFilterProxyImpl(generator);
    }

    @Override
    public ContextRuntimeDescriptor getContextRuntimeDescriptor() {
        return this.contextRuntimeDescriptor;
    }

    @Override
    public Iterator<EventBean> iterator(int statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, new ContextPartitionSelectorAll());
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public SafeIterator<EventBean> safeIterator(int statementId) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, new ContextPartitionSelectorAll());
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public Iterator<EventBean> iterator(int statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArrayIterator(instances);
    }

    @Override
    public SafeIterator<EventBean> safeIterator(int statementId, ContextPartitionSelector selector) {
        AgentInstance[] instances = this.getAgentInstancesForStmt(statementId, selector);
        return new AgentInstanceArraySafeIterator(instances);
    }

    @Override
    public Map<String, Object> getContextPartitions(int contextPartitionId) {
        for (Map.Entry<Integer, ContextControllerStatementDesc> entry : this.statements.entrySet()) {
            StatementContext statementContext = entry.getValue().getLightweight().getStatementContext();
            StatementCPCacheService resourceService = statementContext.getStatementCPCacheService();
            StatementResourceHolder holder = resourceService.makeOrGetEntryCanNull(contextPartitionId, statementContext);
            if (holder == null) continue;
            return ((MappedEventBean)holder.getAgentInstanceContext().getContextProperties()).getProperties();
        }
        return null;
    }

    @Override
    public MappedEventBean getContextPropertiesEvent(int contextPartitionId) {
        Map<String, Object> props = this.getContextPartitions(contextPartitionId);
        return this.statementContextCreate.getEventBeanTypedEventFactory().adapterForTypedMap(props, this.contextDefinition.getEventTypeContextProperties());
    }

    public ContextPartitionIdentifier getContextPartitionIdentifier(Object[] partitionKeys) {
        if (this.contextDefinition.getControllerFactories().length == 1) {
            return this.contextDefinition.getControllerFactories()[0].getContextPartitionIdentifier(partitionKeys[0]);
        }
        ContextPartitionIdentifier[] identifiers = new ContextPartitionIdentifier[partitionKeys.length];
        for (int i = 0; i < partitionKeys.length; ++i) {
            identifiers[i] = this.contextDefinition.getControllerFactories()[i].getContextPartitionIdentifier(partitionKeys[i]);
        }
        return new ContextPartitionIdentifierNested(identifiers);
    }

    @Override
    public ContextPartitionCollection getContextPartitions(ContextPartitionSelector selector) {
        if (selector instanceof ContextPartitionSelectorAll) {
            HashMap<Integer, ContextPartitionIdentifier> map = new HashMap<Integer, ContextPartitionIdentifier>();
            Collection<Integer> ids = this.contextPartitionIdService.getIds();
            for (int id : ids) {
                Object[] partitionKeys = this.contextPartitionIdService.getPartitionKeys(id);
                if (partitionKeys == null) continue;
                ContextPartitionIdentifier identifier = this.getContextPartitionIdentifier(partitionKeys);
                map.put(id, identifier);
            }
            return new ContextPartitionCollection(map);
        }
        Collection<Integer> ids = this.getRealization().getAgentInstanceIds(selector);
        HashMap<Integer, ContextPartitionIdentifier> identifiers = new HashMap<Integer, ContextPartitionIdentifier>();
        for (int id : ids) {
            Object[] partitionKeys = this.contextPartitionIdService.getPartitionKeys(id);
            if (partitionKeys == null) continue;
            ContextPartitionIdentifier identifier = this.getContextPartitionIdentifier(partitionKeys);
            identifiers.put(id, identifier);
        }
        return new ContextPartitionCollection(identifiers);
    }

    @Override
    public Set<Integer> getContextPartitionIds(ContextPartitionSelector selector) {
        return new LinkedHashSet<Integer>(this.contextPartitionIdService.getIds());
    }

    @Override
    public long getContextPartitionCount() {
        return this.contextPartitionIdService.getCount();
    }

    @Override
    public ContextPartitionIdentifier getContextIdentifier(int agentInstanceId) {
        Object[] partitionKeys = this.contextPartitionIdService.getPartitionKeys(agentInstanceId);
        return partitionKeys == null ? null : this.getContextPartitionIdentifier(partitionKeys);
    }

    public Collection<Integer> getAgentInstanceIds(ContextPartitionSelector selector) {
        return this.getRealization().getAgentInstanceIds(selector);
    }

    @Override
    public StatementAIResourceRegistry allocateAgentInstanceResourceRegistry(AIRegistryRequirements registryRequirements) {
        if (this.contextDefinition.getControllerFactories().length == 1) {
            return this.contextDefinition.getControllerFactories()[0].allocateAgentInstanceResourceRegistry(registryRequirements);
        }
        return AIRegistryUtil.allocateRegistries(registryRequirements, AIRegistryFactoryMap.INSTANCE);
    }

    public ContextPartitionIdService getContextPartitionIdService() {
        return this.contextPartitionIdService;
    }

    @Override
    public DataInputOutputSerde[] getContextPartitionKeySerdes() {
        return this.contextPartitionKeySerdes;
    }

    @Override
    public int getNumNestingLevels() {
        return this.contextDefinition.getControllerFactories().length;
    }

    public DataInputOutputSerde[] getContextPartitionKeySerdeSubset(int nestingLevel) {
        return ContextManagerResident.getContextPartitionKeySerdeSubset(nestingLevel, this.contextPartitionKeySerdes);
    }

    public static DataInputOutputSerde[] getContextPartitionKeySerdeSubset(int nestingLevel, DataInputOutputSerde[] allSerdes) {
        DataInputOutputSerde[] serdes = new DataInputOutputSerde[nestingLevel - 1];
        for (int i = 0; i < nestingLevel - 1; ++i) {
            serdes[i] = allSerdes[i];
        }
        return serdes;
    }

    @Override
    public synchronized void addListener(ContextPartitionStateListener listener) {
        if (this.listenersLazy == null) {
            this.listenersLazy = new CopyOnWriteArrayList();
        }
        this.listenersLazy.add(listener);
    }

    @Override
    public void removeListener(ContextPartitionStateListener listener) {
        if (this.listenersLazy == null) {
            return;
        }
        this.listenersLazy.remove(listener);
    }

    public CopyOnWriteArrayList<ContextPartitionStateListener> getListenersMayNull() {
        return this.listenersLazy;
    }

    @Override
    public Iterator<ContextPartitionStateListener> getListeners() {
        if (this.listenersLazy == null) {
            return Collections.emptyIterator();
        }
        return this.listenersLazy.iterator();
    }

    @Override
    public void removeListeners() {
        if (this.listenersLazy == null) {
            return;
        }
        this.listenersLazy.clear();
    }

    @Override
    public boolean handleFilterFault(EventBean theEvent, long version) {
        return this.getRealization().handleFilterFault(theEvent, version);
    }

    @Override
    public void clearCaches() {
        if (this.contextPartitionIdService != null) {
            this.contextPartitionIdService.clearCaches();
        }
    }

    private AgentInstance[] getAgentInstancesForStmt(int statementId, ContextPartitionSelector selector) {
        Collection<Integer> agentInstanceIds = this.getAgentInstanceIds(selector);
        if (agentInstanceIds == null || agentInstanceIds.isEmpty()) {
            return new AgentInstance[0];
        }
        for (Map.Entry<Integer, ContextControllerStatementDesc> entry : this.statements.entrySet()) {
            if (entry.getValue().getLightweight().getStatementContext().getStatementId() != statementId) continue;
            List<AgentInstance> agentInstances = ContextManagerUtil.getAgentInstances(entry.getValue(), agentInstanceIds);
            return agentInstances.toArray(new AgentInstance[agentInstances.size()]);
        }
        return null;
    }
}

