/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSetterBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesRuntime;
import com.espertech.esper.common.internal.context.module.ModuleIndexMeta;
import com.espertech.esper.common.internal.epl.namedwindow.compile.NamedWindowCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.script.core.NameAndParamNum;
import com.espertech.esper.common.internal.epl.script.core.NameParamNumAndModule;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeRegistry;
import com.espertech.esper.common.internal.type.NameAndModule;
import java.util.Collection;
import java.util.HashSet;

public class ModuleDependenciesCompileTime {
    private final Collection<NameAndModule> pathEventTypes = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathNamedWindows = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathTables = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathVariables = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathContexts = new HashSet<NameAndModule>();
    private final Collection<NameAndModule> pathExpressions = new HashSet<NameAndModule>();
    private final Collection<ModuleIndexMeta> pathIndexes = new HashSet<ModuleIndexMeta>();
    private final Collection<NameParamNumAndModule> pathScripts = new HashSet<NameParamNumAndModule>();
    private final Collection<NameAndModule> pathClasses = new HashSet<NameAndModule>();
    private final Collection<String> publicEventTypes = new HashSet<String>();
    private final Collection<String> publicVariables = new HashSet<String>();

    public void addPathEventType(String eventTypeName, String moduleName) {
        this.pathEventTypes.add(new NameAndModule(eventTypeName, moduleName));
    }

    public void addPathNamedWindow(String namedWindowName, String moduleName) {
        this.pathNamedWindows.add(new NameAndModule(namedWindowName, moduleName));
    }

    public void addPathTable(String tableName, String moduleName) {
        this.pathTables.add(new NameAndModule(tableName, moduleName));
    }

    public void addPathVariable(String variableName, String moduleName) {
        this.pathVariables.add(new NameAndModule(variableName, moduleName));
    }

    public void addPathContext(String contextName, String moduleName) {
        this.pathContexts.add(new NameAndModule(contextName, moduleName));
    }

    public void addPathExpression(String expressionName, String moduleName) {
        this.pathExpressions.add(new NameAndModule(expressionName, moduleName));
    }

    public void addPathScript(NameAndParamNum key, String moduleName) {
        this.pathScripts.add(new NameParamNumAndModule(key.getName(), key.getParamNum(), moduleName));
    }

    public void addPublicEventType(String eventTypeName) {
        this.publicEventTypes.add(eventTypeName);
    }

    public void addPublicVariable(String variableName) {
        this.publicVariables.add(variableName);
    }

    public void addPathClass(String className, String moduleName) {
        this.pathClasses.add(new NameAndModule(className, moduleName));
    }

    public void addPathIndex(boolean namedWindow, String infraName, String infraModuleName, String indexName, String indexModuleName, NamedWindowCompileTimeRegistry namedWindowCompileTimeRegistry, TableCompileTimeRegistry tableCompileTimeRegistry) {
        if (indexName == null) {
            return;
        }
        if (!namedWindow && infraName.equals(indexName)) {
            return;
        }
        if (namedWindow && namedWindowCompileTimeRegistry.getNamedWindows().get(infraName) != null) {
            return;
        }
        if (!namedWindow && tableCompileTimeRegistry.getTables().get(infraName) != null) {
            return;
        }
        this.pathIndexes.add(new ModuleIndexMeta(namedWindow, infraName, infraModuleName, indexName, indexModuleName));
    }

    public Collection<String> getPublicEventTypes() {
        return this.publicEventTypes;
    }

    public Collection<NameAndModule> getPathEventTypes() {
        return this.pathEventTypes;
    }

    public void make(CodegenMethod method, CodegenClassScope classScope) {
        CodegenSetterBuilder builder = new CodegenSetterBuilder(ModuleDependenciesRuntime.EPTYPE, ModuleDependenciesCompileTime.class, "md", classScope, method);
        builder.expressionDefaultChecked("pathEventTypes", NameAndModule.makeArrayNullIfEmpty(this.pathEventTypes)).expressionDefaultChecked("pathNamedWindows", NameAndModule.makeArrayNullIfEmpty(this.pathNamedWindows)).expressionDefaultChecked("pathTables", NameAndModule.makeArrayNullIfEmpty(this.pathTables)).expressionDefaultChecked("pathVariables", NameAndModule.makeArrayNullIfEmpty(this.pathVariables)).expressionDefaultChecked("pathContexts", NameAndModule.makeArrayNullIfEmpty(this.pathContexts)).expressionDefaultChecked("pathExpressions", NameAndModule.makeArrayNullIfEmpty(this.pathExpressions)).expressionDefaultChecked("pathIndexes", ModuleIndexMeta.makeArrayNullIfEmpty(this.pathIndexes)).expressionDefaultChecked("pathScripts", NameParamNumAndModule.makeArrayNullIfEmpty(this.pathScripts)).expressionDefaultChecked("pathClasses", NameAndModule.makeArrayNullIfEmpty(this.pathClasses)).expressionDefaultChecked("publicEventTypes", this.makeStringArrayNullIfEmpty(this.publicEventTypes)).expressionDefaultChecked("publicVariables", this.makeStringArrayNullIfEmpty(this.publicVariables));
        method.getBlock().methodReturn(builder.getRefName());
    }

    private CodegenExpression makeStringArrayNullIfEmpty(Collection<String> values) {
        return values.isEmpty() ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.constant(values.toArray(new String[0]));
    }
}

