/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Collection;
import java.util.Set;

public class ModuleIndexMeta {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ModuleIndexMeta.class);
    public static final ModuleIndexMeta[] EMPTY_ARRAY = new ModuleIndexMeta[0];
    private final boolean namedWindow;
    private final String infraName;
    private final String infraModuleName;
    private final String indexName;
    private final String indexModuleName;

    public ModuleIndexMeta(boolean namedWindow, String infraName, String infraModuleName, String indexName, String indexModuleName) {
        this.namedWindow = namedWindow;
        this.infraName = infraName;
        this.infraModuleName = infraModuleName;
        this.indexName = indexName;
        this.indexModuleName = indexModuleName;
    }

    public boolean isNamedWindow() {
        return this.namedWindow;
    }

    public String getInfraName() {
        return this.infraName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getInfraModuleName() {
        return this.infraModuleName;
    }

    public String getIndexModuleName() {
        return this.indexModuleName;
    }

    public static CodegenExpression makeArrayNullIfEmpty(Collection<ModuleIndexMeta> names) {
        if (names.isEmpty()) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpression[] expressions = new CodegenExpression[names.size()];
        int count = 0;
        for (ModuleIndexMeta entry : names) {
            expressions[count++] = entry.make();
        }
        return CodegenExpressionBuilder.newArrayWithInit(EPTYPE, expressions);
    }

    private CodegenExpression make() {
        return CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.constant(this.namedWindow), CodegenExpressionBuilder.constant(this.infraName), CodegenExpressionBuilder.constant(this.infraModuleName), CodegenExpressionBuilder.constant(this.indexName), CodegenExpressionBuilder.constant(this.indexModuleName));
    }

    public static ModuleIndexMeta[] toArray(Set<ModuleIndexMeta> moduleIndexes) {
        if (moduleIndexes.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return moduleIndexes.toArray(new ModuleIndexMeta[moduleIndexes.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleIndexMeta that = (ModuleIndexMeta)o;
        if (this.namedWindow != that.namedWindow) {
            return false;
        }
        if (this.infraName != null ? !this.infraName.equals(that.infraName) : that.infraName != null) {
            return false;
        }
        if (this.infraModuleName != null ? !this.infraModuleName.equals(that.infraModuleName) : that.infraModuleName != null) {
            return false;
        }
        if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) {
            return false;
        }
        return this.indexModuleName != null ? this.indexModuleName.equals(that.indexModuleName) : that.indexModuleName == null;
    }

    public int hashCode() {
        int result = this.namedWindow ? 1 : 0;
        result = 31 * result + (this.infraName != null ? this.infraName.hashCode() : 0);
        result = 31 * result + (this.infraModuleName != null ? this.infraModuleName.hashCode() : 0);
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        result = 31 * result + (this.indexModuleName != null ? this.indexModuleName.hashCode() : 0);
        return result;
    }
}

