/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerExceptionType;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextStatementEventEvaluator;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceFilterProxy;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementAgentInstancePreload;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.context.util.StatementContextRuntimeServices;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewTerminable;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.filtersvc.FilterHandle;
import com.espertech.esper.common.internal.metrics.audit.AuditProvider;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AgentInstanceUtil {
    public static void evaluateEventForStatement(EventBean theEvent, Map<String, Object> optionalTriggeringPattern, List<AgentInstance> agentInstances, AgentInstanceContext agentInstanceContextCreate) {
        ContextStatementEventEvaluator evaluator = agentInstanceContextCreate.getContextServiceFactory().getContextStatementEventEvaluator();
        if (theEvent != null) {
            evaluator.evaluateEventForStatement(theEvent, agentInstances, agentInstanceContextCreate);
        }
        if (optionalTriggeringPattern != null) {
            for (Map.Entry<String, Object> entry : optionalTriggeringPattern.entrySet()) {
                EventBean[] eventsArray;
                if (entry.getValue() instanceof EventBean) {
                    evaluator.evaluateEventForStatement((EventBean)entry.getValue(), agentInstances, agentInstanceContextCreate);
                    continue;
                }
                if (!(entry.getValue() instanceof EventBean[])) continue;
                for (EventBean eventElement : eventsArray = (EventBean[])entry.getValue()) {
                    evaluator.evaluateEventForStatement(eventElement, agentInstances, agentInstanceContextCreate);
                }
            }
        }
    }

    public static void contextPartitionTerminate(int agentInstanceId, ContextControllerStatementDesc statementDesc, ContextController[] contextControllers, Map<String, Object> terminationProperties, boolean leaveLocksAcquired, List<AgentInstance> agentInstancesLocksHeld) {
        StatementContext statementContext = statementDesc.getLightweight().getStatementContext();
        StatementResourceHolder holder = statementContext.getStatementCPCacheService().makeOrGetEntryCanNull(agentInstanceId, statementContext);
        if (terminationProperties != null) {
            MappedEventBean mappedEventBean = (MappedEventBean)holder.getAgentInstanceContext().getContextProperties();
            if (contextControllers.length == 1) {
                mappedEventBean.getProperties().putAll(terminationProperties);
            } else {
                ContextController lastController = contextControllers[contextControllers.length - 1];
                String lastContextName = lastController.getFactory().getFactoryEnv().getContextName();
                Map inner = (Map)mappedEventBean.getProperties().get(lastContextName);
                if (inner != null) {
                    inner.putAll(terminationProperties);
                }
            }
        }
        AgentInstanceUtil.stop(holder.getAgentInstanceStopCallback(), holder.getAgentInstanceContext(), holder.getFinalView(), false, leaveLocksAcquired);
        if (leaveLocksAcquired) {
            agentInstancesLocksHeld.add(new AgentInstance(holder.getAgentInstanceStopCallback(), holder.getAgentInstanceContext(), holder.getFinalView()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(AgentInstanceMgmtCallback stopCallback, AgentInstanceContext agentInstanceContext, Viewable finalView, boolean isStatementStop, boolean leaveLocksAcquired) {
        agentInstanceContext.getInstrumentationProvider().qContextPartitionDestroy(agentInstanceContext);
        StatementAgentInstanceLock lock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        lock.acquireWriteLock();
        try {
            if (finalView instanceof OutputProcessViewTerminable && !isStatementStop) {
                OutputProcessViewTerminable terminable = (OutputProcessViewTerminable)((Object)finalView);
                terminable.terminated();
            }
            AgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext);
            if (agentInstanceContext.getStatementContext().getStatementAIResourceRegistry() != null) {
                agentInstanceContext.getStatementContext().getStatementAIResourceRegistry().deassign(agentInstanceContext.getAgentInstanceId());
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().setDestroyed(true);
            agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(Long.MAX_VALUE);
            if (agentInstanceContext.getAgentInstanceId() != -1) {
                agentInstanceContext.getAuditProvider().contextPartition(false, agentInstanceContext);
            }
        }
        finally {
            if (!leaveLocksAcquired) {
                if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                    agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
                }
                lock.releaseWriteLock();
            }
            agentInstanceContext.getInstrumentationProvider().aContextPartitionDestroy();
        }
    }

    public static void stopSafe(AgentInstanceMgmtCallback stopMethod, AgentInstanceContext agentInstanceContext) {
        AgentInstanceStopServices stopServices = new AgentInstanceStopServices(agentInstanceContext);
        Collection<AgentInstanceMgmtCallback> additionalTerminations = agentInstanceContext.getTerminationCallbackRO();
        for (AgentInstanceMgmtCallback stop : additionalTerminations) {
            try {
                stop.stop(stopServices);
            }
            catch (RuntimeException e) {
                AgentInstanceUtil.handleStopException(e, agentInstanceContext);
            }
        }
        try {
            stopMethod.stop(stopServices);
        }
        catch (RuntimeException e) {
            AgentInstanceUtil.handleStopException(e, agentInstanceContext);
        }
    }

    public static AgentInstanceMgmtCallback finalizeSafeStopCallbacks(List<AgentInstanceMgmtCallback> stopCallbacks) {
        AgentInstanceMgmtCallback[] stopCallbackArray = stopCallbacks.toArray(new AgentInstanceMgmtCallback[stopCallbacks.size()]);
        return new AgentInstanceFinalizedMgmtCallback(stopCallbackArray);
    }

    private static void handleStopException(RuntimeException e, AgentInstanceContext agentInstanceContext) {
        agentInstanceContext.getExceptionHandlingService().handleException(e, agentInstanceContext.getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.UNDEPLOY, null);
    }

    public static AgentInstance startStatement(StatementContextRuntimeServices services, int assignedContextId, ContextControllerStatementDesc statementDesc, MappedEventBean contextBean, AgentInstanceFilterProxy proxy) {
        StatementAgentInstanceFactoryResult result = AgentInstanceUtil.start(services, statementDesc, assignedContextId, contextBean, proxy, false);
        return new AgentInstance(result.getStopCallback(), result.getAgentInstanceContext(), result.getFinalView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatementAgentInstanceFactoryResult start(StatementContextRuntimeServices services, ContextControllerStatementDesc statement, int agentInstanceId, MappedEventBean contextProperties, AgentInstanceFilterProxy agentInstanceFilterProxy, boolean isRecoveringResilient) {
        StatementContext statementContext = statement.getLightweight().getStatementContext();
        StatementAgentInstanceLock lock = statementContext.getStatementAIFactoryProvider().getFactory().obtainAgentInstanceLock(statementContext, agentInstanceId);
        EPStatementAgentInstanceHandle agentInstanceHandle = new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), agentInstanceId, lock);
        AuditProvider auditProvider = statementContext.getStatementInformationals().getAuditProvider();
        InstrumentationCommon instrumentationProvider = statementContext.getStatementInformationals().getInstrumentationProvider();
        AgentInstanceContext agentInstanceContext = new AgentInstanceContext(statementContext, agentInstanceHandle, agentInstanceFilterProxy, contextProperties, auditProvider, instrumentationProvider);
        if (agentInstanceId != -1) {
            agentInstanceContext.getAuditProvider().contextPartition(true, agentInstanceContext);
        }
        StatementAgentInstanceLock statementAgentInstanceLock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
        agentInstanceContext.getInstrumentationProvider().qContextPartitionAllocate(agentInstanceContext);
        statementAgentInstanceLock.acquireWriteLock();
        try {
            StatementAgentInstanceFactoryResult startResult = statement.getLightweight().getStatementProvider().getStatementAIFactoryProvider().getFactory().newContext(agentInstanceContext, isRecoveringResilient);
            startResult.getFinalView().setChild(statement.getContextMergeView());
            StatementAIResourceRegistry aiResourceRegistry = statementContext.getStatementAIResourceRegistry();
            AIRegistryUtil.assignFutures(aiResourceRegistry, agentInstanceId, startResult.getOptionalAggegationService(), startResult.getPriorStrategies(), startResult.getPreviousGetterStrategies(), startResult.getSubselectStrategies(), startResult.getTableAccessStrategies(), startResult.getRowRecogPreviousStrategy());
            if (startResult.getPreloadList() != null) {
                for (StatementAgentInstancePreload preload : startResult.getPreloadList()) {
                    preload.executePreload();
                }
            }
            if (startResult.getPostContextMergeRunnable() != null) {
                startResult.getPostContextMergeRunnable().run();
            }
            StatementResourceHolder holder = services.getStatementResourceHolderBuilder().build(agentInstanceContext, startResult);
            statementContext.getStatementCPCacheService().getStatementResourceService().setPartitioned(agentInstanceId, holder);
            StatementAgentInstanceFactoryResult statementAgentInstanceFactoryResult = startResult;
            return statementAgentInstanceFactoryResult;
        }
        finally {
            if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            statementAgentInstanceLock.releaseWriteLock();
            agentInstanceContext.getInstrumentationProvider().aContextPartitionAllocate();
        }
    }

    public static boolean evaluateFilterForStatement(EventBean theEvent, AgentInstanceContext agentInstanceContext, FilterHandle filterHandle) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>();
        agentInstanceContext.getFilterService().evaluate(theEvent, callbacks, agentInstanceContext.getStatementContext().getStatementId(), agentInstanceContext);
        try {
            agentInstanceContext.getVariableManagementService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                if (!handle.equals(filterHandle)) continue;
                return true;
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch();
        }
        catch (RuntimeException ex) {
            agentInstanceContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.PROCESS, theEvent);
        }
        return false;
    }

    public static StatementAgentInstanceLock newLock(StatementContext statementContext, int cpid) {
        return statementContext.getStatementAgentInstanceLockFactory().getStatementLock(statementContext.getStatementName(), cpid, statementContext.getAnnotations(), statementContext.isStatelessSelect(), statementContext.getStatementType());
    }

    public static class AgentInstanceFinalizedMgmtCallback
    implements AgentInstanceMgmtCallback {
        private final AgentInstanceMgmtCallback[] mgmtCallbackArray;

        private AgentInstanceFinalizedMgmtCallback(AgentInstanceMgmtCallback[] mgmtCallbackArray) {
            this.mgmtCallbackArray = mgmtCallbackArray;
        }

        @Override
        public void stop(AgentInstanceStopServices services) {
            for (AgentInstanceMgmtCallback callback : this.mgmtCallbackArray) {
                try {
                    callback.stop(services);
                }
                catch (RuntimeException e) {
                    AgentInstanceUtil.handleStopException(e, services.getAgentInstanceContext());
                }
            }
        }

        @Override
        public void transfer(AgentInstanceTransferServices services) {
            for (AgentInstanceMgmtCallback callback : this.mgmtCallbackArray) {
                try {
                    callback.transfer(services);
                }
                catch (RuntimeException e) {
                    services.getAgentInstanceContext().getExceptionHandlingService().handleException(e, services.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.STAGE, null);
                }
            }
        }
    }
}

