/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerPortableInfo;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedValidation;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedValidationItem;
import java.util.Locale;

public class ContextPropertyRegistry {
    public static final String CONTEXT_PREFIX = "context";
    private final EventType contextEventType;
    private final ContextControllerPortableInfo[] controllerValidations;

    public ContextPropertyRegistry(ContextMetaData metaData) {
        this.contextEventType = metaData.getEventType();
        this.controllerValidations = metaData.getValidationInfos();
    }

    public boolean isPartitionProperty(EventType fromType, String propertyName) {
        String name = this.getPartitionContextPropertyName(fromType, propertyName);
        return name != null;
    }

    public String getPartitionContextPropertyName(EventType fromType, String propertyName) {
        if (this.controllerValidations.length == 1 && this.controllerValidations[0] instanceof ContextControllerKeyedValidation) {
            ContextControllerKeyedValidation partitioned = (ContextControllerKeyedValidation)this.controllerValidations[0];
            for (ContextControllerKeyedValidationItem item : partitioned.getItems()) {
                if (item.getEventType() != fromType) continue;
                for (int i = 0; i < item.getPropertyNames().length; ++i) {
                    if (!item.getPropertyNames()[i].equals(propertyName)) continue;
                    return "key" + (i + 1);
                }
            }
        }
        return null;
    }

    public boolean isContextPropertyPrefix(String prefixName) {
        return prefixName != null && prefixName.toLowerCase(Locale.ENGLISH).equals(CONTEXT_PREFIX);
    }

    public EventType getContextEventType() {
        return this.contextEventType;
    }
}

