/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationStateFactoryForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationVColAccess;
import com.espertech.esper.common.internal.epl.agg.core.AggregationVColMethod;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AggregationClassAssignment {
    private final int offset;
    private final CodegenMemberCol members;
    private final CodegenCtor ctor;
    private final List<ExprForge[]> methodForges;
    private final List<AggregationForgeFactory> methodFactories;
    private final List<AggregationStateFactoryForge> accessStateFactories;
    private final List<AggregationVColMethod> vcolMethods = new ArrayList<AggregationVColMethod>(8);
    private final List<AggregationVColAccess> vcolAccess = new ArrayList<AggregationVColAccess>(8);
    private String className;
    private String memberName;

    public AggregationClassAssignment(int offset, Class forgeClass, CodegenClassScope classScope) {
        this.offset = offset;
        this.ctor = new CodegenCtor(forgeClass, classScope, Collections.emptyList());
        this.members = new CodegenMemberCol();
        this.methodForges = new ArrayList<ExprForge[]>();
        this.methodFactories = new ArrayList<AggregationForgeFactory>();
        this.accessStateFactories = new ArrayList<AggregationStateFactoryForge>();
    }

    public void addMethod(AggregationVColMethod vcol) {
        this.vcolMethods.add(vcol);
    }

    public void addAccess(AggregationVColAccess vcol) {
        this.vcolAccess.add(vcol);
    }

    public void add(AggregationForgeFactory methodFactory, ExprForge[] forges) {
        this.methodFactories.add(methodFactory);
        this.methodForges.add(forges);
    }

    public void add(AggregationStateFactoryForge factory) {
        this.accessStateFactories.add(factory);
    }

    public int size() {
        return this.members.getMembersPerColumn().size();
    }

    public CodegenMemberCol getMembers() {
        return this.members;
    }

    public CodegenCtor getCtor() {
        return this.ctor;
    }

    public AggregationForgeFactory[] getMethodFactories() {
        return this.methodFactories.toArray(new AggregationForgeFactory[0]);
    }

    public AggregationStateFactoryForge[] getAccessStateFactories() {
        return this.accessStateFactories.toArray(new AggregationStateFactoryForge[0]);
    }

    public ExprForge[][] getMethodForges() {
        return (ExprForge[][])this.methodForges.toArray((T[])new ExprForge[0][]);
    }

    public int getMemberSize() {
        return this.members.getMembers().size();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<AggregationVColMethod> getVcolMethods() {
        return this.vcolMethods;
    }

    public List<AggregationVColAccess> getVcolAccess() {
        return this.vcolAccess;
    }
}

