/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowCtorDesc;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.fabric.FabricTypeCollector;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class AggregationServiceCodegenUtil {
    public static CodegenMethod computeMultiKeyCodegen(int idNumber, ExprNode[] partitionForges, MultiKeyClassRef optionalMultiKey, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        Consumer<CodegenMethod> code = method -> {
            if (optionalMultiKey == null || optionalMultiKey.getClassNameMK() == null) {
                CodegenExpression expression = partitionForges[0].getForge().evaluateCodegen(EPTypePremade.OBJECT.getEPType(), (CodegenMethodScope)method, exprSymbol, classScope);
                exprSymbol.derivedSymbolsCodegen((CodegenMethod)method, method.getBlock(), classScope);
                method.getBlock().methodReturn(expression);
                return;
            }
            CodegenExpression[] expressions = new CodegenExpression[partitionForges.length];
            for (int i = 0; i < partitionForges.length; ++i) {
                expressions[i] = partitionForges[i].getForge().evaluateCodegen(EPTypePremade.OBJECT.getEPType(), (CodegenMethodScope)method, exprSymbol, classScope);
            }
            exprSymbol.derivedSymbolsCodegen((CodegenMethod)method, method.getBlock(), classScope);
            method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(optionalMultiKey.getClassNameMK(), expressions));
        };
        return namedMethods.addMethodWithSymbols(EPTypePremade.OBJECT.getEPType(), "computeKeyArrayCodegen_" + idNumber, CodegenNamedParam.from(EventBean.EPTYPEARRAY, "eventsPerStream", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), AggregationServiceCodegenUtil.class, classScope, code, exprSymbol);
    }

    public static void generateIncidentals(boolean hasRefcount, boolean hasLastUpdTime, AggregationRowCtorDesc rowCtorDesc) {
        CodegenNamedMethods namedMethods = rowCtorDesc.getNamedMethods();
        CodegenClassScope classScope = rowCtorDesc.getClassScope();
        List<CodegenTypedParam> rowMembers = rowCtorDesc.getRowMembers();
        if (hasRefcount) {
            rowMembers.add(new CodegenTypedParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "refcount").setFinal(false));
        }
        namedMethods.addMethod(EPTypePremade.VOID.getEPType(), "increaseRefcount", Collections.emptyList(), AggregationServiceCodegenUtil.class, classScope, hasRefcount ? method -> method.getBlock().increment(CodegenExpressionBuilder.ref("refcount")) : method -> {});
        namedMethods.addMethod(EPTypePremade.VOID.getEPType(), "decreaseRefcount", Collections.emptyList(), AggregationServiceCodegenUtil.class, classScope, hasRefcount ? method -> method.getBlock().decrement(CodegenExpressionBuilder.ref("refcount")) : method -> {});
        namedMethods.addMethod(EPTypePremade.LONGPRIMITIVE.getEPType(), "getRefcount", Collections.emptyList(), AggregationServiceCodegenUtil.class, classScope, hasRefcount ? method -> method.getBlock().methodReturn(CodegenExpressionBuilder.ref("refcount")) : method -> method.getBlock().methodReturn(CodegenExpressionBuilder.constant(1)));
        if (hasLastUpdTime) {
            rowMembers.add(new CodegenTypedParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "lastUpd").setFinal(false));
        }
        namedMethods.addMethod(EPTypePremade.VOID.getEPType(), "setLastUpdateTime", CodegenNamedParam.from(EPTypePremade.LONGPRIMITIVE.getEPType(), "time"), AggregationServiceCodegenUtil.class, classScope, hasLastUpdTime ? method -> method.getBlock().assignRef("lastUpd", (CodegenExpression)CodegenExpressionBuilder.ref("time")) : method -> method.getBlock().methodThrowUnsupported());
        namedMethods.addMethod(EPTypePremade.LONGPRIMITIVE.getEPType(), "getLastUpdateTime", Collections.emptyList(), AggregationServiceCodegenUtil.class, classScope, hasLastUpdTime ? method -> method.getBlock().methodReturn(CodegenExpressionBuilder.ref("lastUpd")) : method -> method.getBlock().methodThrowUnsupported());
    }

    public static void appendIncidentals(boolean hasRefcount, boolean hasLastUpdTime, FabricTypeCollector fabricTypeCollector) {
        if (hasRefcount) {
            fabricTypeCollector.builtin(Integer.TYPE);
        }
        if (hasLastUpdTime) {
            fabricTypeCollector.builtin(Long.TYPE);
        }
    }
}

