/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassAssignment;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassAssignmentPerLevel;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryCompiler;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceNullFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationStateFactoryForge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class AggregationServiceFactoryCompilerSerde {
    private static final CodegenExpressionRef INPUT = CodegenExpressionBuilder.ref("input");
    private static final CodegenExpressionRef OUTPUT = CodegenExpressionBuilder.ref("output");
    private static final CodegenExpressionRef UNIT_KEY = CodegenExpressionBuilder.ref("unitKey");
    private static final CodegenExpressionRef WRITER = CodegenExpressionBuilder.ref("writer");

    protected static void makeRowSerde(boolean isTargetHA, AggregationClassAssignmentPerLevel assignments, Class forgeClass, BiConsumer<CodegenMethod, Integer> readConsumer, BiConsumer<CodegenMethod, Integer> writeConsumer, List<CodegenInnerClass> innerClasses, CodegenClassScope classScope, String providerClassName, AggregationClassNames classNames) {
        if (assignments.getOptionalTop() != null) {
            AggregationServiceFactoryCompilerSerde.makeRowSerdeForLevel(isTargetHA, assignments.getOptionalTop(), classNames.getRowTop(), classNames.getRowSerdeTop(), -1, forgeClass, readConsumer, writeConsumer, classScope, innerClasses, providerClassName);
        }
        if (assignments.getOptionalPerLevel() != null) {
            for (int i = 0; i < assignments.getOptionalPerLevel().length; ++i) {
                AggregationServiceFactoryCompilerSerde.makeRowSerdeForLevel(isTargetHA, assignments.getOptionalPerLevel()[i], classNames.getRowPerLevel(i), classNames.getRowSerdePerLevel(i), i, forgeClass, readConsumer, writeConsumer, classScope, innerClasses, providerClassName);
            }
        }
    }

    private static void makeRowSerdeForLevel(boolean isTargetHA, AggregationClassAssignment[] assignments, String classNameRow, String classNameSerde, int level, Class forgeClass, BiConsumer<CodegenMethod, Integer> readConsumer, BiConsumer<CodegenMethod, Integer> writeConsumer, CodegenClassScope classScope, List<CodegenInnerClass> innerClasses, String providerClassName) {
        if (assignments.length == 1 || !isTargetHA || forgeClass == AggregationServiceNullFactory.INSTANCE.getClass()) {
            CodegenInnerClass inner = AggregationServiceFactoryCompilerSerde.makeRowSerdeForLevel(isTargetHA, assignments[0], classNameRow, classNameSerde, level, forgeClass, readConsumer, writeConsumer, classScope, providerClassName);
            inner.addInterfaceImplemented(DataInputOutputSerde.EPTYPE);
            innerClasses.add(inner);
            return;
        }
        String[] classNamesSerde = new String[assignments.length];
        for (int i = 0; i < assignments.length; ++i) {
            classNamesSerde[i] = classNameSerde + "_" + i;
            CodegenInnerClass inner = AggregationServiceFactoryCompilerSerde.makeRowSerdeForLevel(isTargetHA, assignments[i], assignments[i].getClassName(), classNamesSerde[i], level, forgeClass, readConsumer, writeConsumer, classScope, providerClassName);
            innerClasses.add(inner);
        }
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(classNameSerde.length());
        for (int i = 0; i < assignments.length; ++i) {
            members.add(new CodegenTypedParam(classNamesSerde[i], "s" + i));
        }
        CodegenCtor ctor = AggregationServiceFactoryCompilerSerde.makeCtor(forgeClass, providerClassName, classScope);
        for (int i = 0; i < assignments.length; ++i) {
            ctor.getBlock().assignRef("s" + i, CodegenExpressionBuilder.newInstance(classNamesSerde[i], CodegenExpressionBuilder.ref("o")));
        }
        CodegenMethod writeMethod = AggregationServiceFactoryCompilerSerde.makeWriteMethod(classScope);
        for (int i = 0; i < assignments.length; ++i) {
            writeMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("s" + i), "write", CodegenExpressionBuilder.ref("object"), OUTPUT, UNIT_KEY, WRITER);
        }
        CodegenMethod readMethod = AggregationServiceFactoryCompilerSerde.makeReadMethod(classNameRow, classScope);
        readMethod.getBlock().declareVar(classNameRow, "r", CodegenExpressionBuilder.newInstance(classNameRow, new CodegenExpression[0]));
        for (int i = 0; i < assignments.length; ++i) {
            readMethod.getBlock().assignRef("r.l" + i, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s" + i), "read", INPUT, UNIT_KEY));
        }
        readMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("r"));
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(writeMethod, "write", methods);
        CodegenStackGenerator.recursiveBuildStack(readMethod, "read", methods);
        CodegenInnerClass serde = new CodegenInnerClass(classNameSerde, DataInputOutputSerde.EPTYPE, ctor, members, methods);
        innerClasses.add(serde);
    }

    private static CodegenInnerClass makeRowSerdeForLevel(boolean isTargetHA, AggregationClassAssignment assignment, String classNameRow, String classNameSerde, int level, Class forgeClass, BiConsumer<CodegenMethod, Integer> readConsumer, BiConsumer<CodegenMethod, Integer> writeConsumer, CodegenClassScope classScope, String providerClassName) {
        CodegenCtor ctor = AggregationServiceFactoryCompilerSerde.makeCtor(forgeClass, providerClassName, classScope);
        CodegenMethod writeMethod = AggregationServiceFactoryCompilerSerde.makeWriteMethod(classScope);
        CodegenMethod readMethod = AggregationServiceFactoryCompilerSerde.makeReadMethod(classNameRow, classScope);
        if (!isTargetHA) {
            String message = "Serde not implemented because the compiler target is not HA";
            readMethod.getBlock().methodThrowUnsupported(message);
            writeMethod.getBlock().methodThrowUnsupported(message);
        } else if (forgeClass == AggregationServiceNullFactory.INSTANCE.getClass()) {
            readMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        } else {
            int i;
            readMethod.getBlock().declareVar(classNameRow, "row", CodegenExpressionBuilder.newInstance(classNameRow, new CodegenExpression[0]));
            readConsumer.accept(readMethod, level);
            AggregationForgeFactory[] methodFactories = assignment.getMethodFactories();
            AggregationStateFactoryForge[] accessStates = assignment.getAccessStateFactories();
            writeMethod.getBlock().declareVar(classNameRow, "row", CodegenExpressionBuilder.cast(classNameRow, (CodegenExpression)CodegenExpressionBuilder.ref("object")));
            writeConsumer.accept(writeMethod, level);
            if (methodFactories != null) {
                for (i = 0; i < methodFactories.length; ++i) {
                    methodFactories[i].getAggregator().writeCodegen(CodegenExpressionBuilder.ref("row"), i, OUTPUT, UNIT_KEY, WRITER, writeMethod, classScope);
                }
                for (i = 0; i < methodFactories.length; ++i) {
                    methodFactories[i].getAggregator().readCodegen(CodegenExpressionBuilder.ref("row"), i, INPUT, UNIT_KEY, readMethod, classScope);
                }
            }
            if (accessStates != null) {
                for (i = 0; i < accessStates.length; ++i) {
                    accessStates[i].getAggregator().writeCodegen(CodegenExpressionBuilder.ref("row"), i, OUTPUT, UNIT_KEY, WRITER, writeMethod, classScope);
                }
                for (i = 0; i < accessStates.length; ++i) {
                    accessStates[i].getAggregator().readCodegen(CodegenExpressionBuilder.ref("row"), i, INPUT, readMethod, UNIT_KEY, classScope);
                }
            }
            readMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("row"));
        }
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(writeMethod, "write", methods);
        CodegenStackGenerator.recursiveBuildStack(readMethod, "read", methods);
        return new CodegenInnerClass(classNameSerde, null, ctor, Collections.emptyList(), methods);
    }

    private static CodegenMethod makeReadMethod(String returnType, CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(returnType, AggregationServiceFactoryCompiler.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(CodegenNamedParam.from(EPTypePremade.DATAINPUT.getEPType(), INPUT.getRef(), EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNIT_KEY.getRef())).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
    }

    private static CodegenMethod makeWriteMethod(CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompiler.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(CodegenNamedParam.from(EPTypePremade.OBJECT.getEPType(), "object", EPTypePremade.DATAOUTPUT.getEPType(), OUTPUT.getRef(), EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNIT_KEY.getRef(), EventBeanCollatedWriter.EPTYPE, WRITER.getRef())).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
    }

    private static CodegenCtor makeCtor(Class forgeClass, String providerClassName, CodegenClassScope classScope) {
        CodegenTypedParam param = new CodegenTypedParam(providerClassName, "o");
        return new CodegenCtor(forgeClass, classScope, Collections.singletonList(param));
    }
}

