/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.avedev;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.RefCountedSet;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterWValueBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.fabric.FabricTypeCollector;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.Iterator;
import java.util.Map;

public class AggregatorAvedev
extends AggregatorMethodWDistinctWFilterWValueBase {
    private CodegenExpressionMember valueSet;
    private CodegenExpressionMember sum;

    public AggregatorAvedev(EPTypeClass optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter) {
        super(optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
    }

    @Override
    public void initForgeFiltered(int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope) {
        this.valueSet = membersColumnized.addMember(col, RefCountedSet.EPTYPE, "valueSet");
        this.sum = membersColumnized.addMember(col, EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "sum");
        rowCtor.getBlock().assignRef(this.valueSet, CodegenExpressionBuilder.newInstance(RefCountedSet.EPTYPE, new CodegenExpression[0]));
    }

    @Override
    protected void applyEvalEnterNonNull(CodegenExpressionRef value, EPType valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        this.applyCodegen(true, value, valueType, method);
    }

    @Override
    protected void applyEvalLeaveNonNull(CodegenExpressionRef value, EPType valueType, CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        this.applyCodegen(false, value, valueType, method);
    }

    @Override
    protected void applyTableEnterNonNull(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTableCodegen(true, value, method);
    }

    @Override
    protected void applyTableLeaveNonNull(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        this.applyTableCodegen(false, value, method);
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.constant(0)).exprDotMethod(this.valueSet, "clear", new CodegenExpression[0]);
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorAvedev.class, "computeAvedev", this.valueSet, this.sum));
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.writeDouble(output, row, this.sum)).staticMethod(RefCountedSet.class, "writePointsDouble", output, AggregatorCodegenUtil.rowDotMember(row, this.valueSet));
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.readDouble(row, this.sum, input)).assignRef(AggregatorCodegenUtil.rowDotMember(row, this.valueSet), CodegenExpressionBuilder.staticMethod(RefCountedSet.class, "readPointsDouble", input));
    }

    @Override
    protected void appendFormatWODistinct(FabricTypeCollector collector) {
        collector.builtin(Double.TYPE);
        collector.refCountedSetOfDouble();
    }

    public static Object computeAvedev(RefCountedSet<Double> valueSet, double sum) {
        int datapoints = valueSet.size();
        if (datapoints == 0) {
            return null;
        }
        double total = 0.0;
        double avg = sum / (double)datapoints;
        Iterator<Map.Entry<Double, Integer>> it = valueSet.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Double, Integer> entry = it.next();
            total += (double)entry.getValue().intValue() * Math.abs(entry.getKey() - avg);
        }
        return total / (double)datapoints;
    }

    private void applyCodegen(boolean enter, CodegenExpression value, EPType valueType, CodegenMethod method) {
        method.getBlock().declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "d", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value, valueType)).exprDotMethod(this.valueSet, enter ? "add" : "remove", CodegenExpressionBuilder.ref("d")).assignCompound(this.sum, enter ? "+" : "-", (CodegenExpression)CodegenExpressionBuilder.ref("d"));
    }

    private void applyTableCodegen(boolean enter, CodegenExpression value, CodegenMethod method) {
        method.getBlock().declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "d", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), value), "doubleValue", new CodegenExpression[0])).exprDotMethod(this.valueSet, enter ? "add" : "remove", CodegenExpressionBuilder.ref("d")).assignCompound(this.sum, enter ? "+" : "-", (CodegenExpression)CodegenExpressionBuilder.ref("d"));
    }
}

