/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.avg;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.method.avg.AggregationPortableValidationAvg;
import com.espertech.esper.common.internal.epl.agg.method.avg.AggregatorAvgBig;
import com.espertech.esper.common.internal.epl.agg.method.avg.AggregatorAvgNonBig;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregationForgeFactoryBase;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethod;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprAvgNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMethodAggUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class AggregationForgeFactoryAvg
extends AggregationForgeFactoryBase {
    protected final ExprAvgNode parent;
    protected final EPTypeClass childType;
    protected final DataInputOutputSerdeForge distinctSerde;
    protected final EPTypeClass resultType;
    protected final MathContext optionalMathContext;
    private final AggregatorMethod aggregator;

    public AggregationForgeFactoryAvg(ExprAvgNode parent, EPTypeClass childType, DataInputOutputSerdeForge distinctSerde, MathContext optionalMathContext) {
        this.parent = parent;
        this.childType = childType;
        this.distinctSerde = distinctSerde;
        this.resultType = this.getAvgAggregatorType(childType);
        this.optionalMathContext = optionalMathContext;
        EPTypeClass distinctValueType = !parent.isDistinct() ? null : childType;
        this.aggregator = this.resultType.getType() == BigInteger.class || this.resultType.getType() == BigDecimal.class ? new AggregatorAvgBig(distinctValueType, distinctSerde, parent.isHasFilter(), parent.getOptionalFilter(), this) : new AggregatorAvgNonBig(distinctValueType, distinctSerde, parent.isHasFilter(), parent.getOptionalFilter(), JavaClassHelper.getBoxedType(childType));
    }

    @Override
    public EPType getResultType() {
        return this.resultType;
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public AggregationPortableValidation getAggregationPortableValidation() {
        return new AggregationPortableValidationAvg(this.parent.isDistinct(), this.parent.isHasFilter(), (EPTypeClass)this.parent.getChildNodes()[0].getForge().getEvaluationType());
    }

    @Override
    public AggregatorMethod getAggregator() {
        return this.aggregator;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    private EPTypeClass getAvgAggregatorType(EPTypeClass type) {
        if (type.getType() == BigDecimal.class || type.getType() == BigInteger.class) {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }
        return EPTypePremade.DOUBLEBOXED.getEPType();
    }
}

