/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.nth;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.epl.agg.core.AggregationSerdeUtil;
import com.espertech.esper.common.internal.epl.agg.method.nth.AggregationNthState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AggregatorNthSerde {
    protected static final short SERDE_VERSION = 1;

    public static void write(DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer, DataInputOutputSerde serdeNullable, Object[] circularBuffer, long numDataPoints, int currentBufferElementPointer, int sizeBuf) throws IOException {
        AggregationSerdeUtil.writeVersion((short)1, output);
        output.writeBoolean(circularBuffer != null);
        if (circularBuffer != null) {
            output.writeLong(numDataPoints);
            output.writeInt(currentBufferElementPointer);
            for (int i = 0; i < sizeBuf; ++i) {
                serdeNullable.write(circularBuffer[i], output, unitKey, writer);
            }
        }
    }

    public static AggregationNthState read(DataInput input, byte[] unitKey, DataInputOutputSerde serdeNullable, int sizeBuf) throws IOException {
        AggregationSerdeUtil.readVersionChecked((short)1, input);
        boolean filled = input.readBoolean();
        AggregationNthState state = new AggregationNthState();
        if (!filled) {
            return state;
        }
        Object[] circularBuffer = new Object[sizeBuf];
        state.setCircularBuffer(circularBuffer);
        state.setNumDataPoints(input.readLong());
        state.setCurrentBufferElementPointer(input.readInt());
        for (int i = 0; i < sizeBuf; ++i) {
            circularBuffer[i] = serdeNullable.read(input, unitKey);
        }
        return state;
    }
}

