/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.rollup;

import com.espertech.esper.common.internal.collection.NumberAscCombinationEnumeration;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupDuplicateException;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupEvalContext;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeBase;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class GroupByRollupNodeRollupOrCube
extends GroupByRollupNodeBase {
    private final boolean cube;

    public GroupByRollupNodeRollupOrCube(boolean cube) {
        this.cube = cube;
    }

    @Override
    public List<int[]> evaluate(GroupByRollupEvalContext context) throws GroupByRollupDuplicateException {
        int[][] childIndexes = this.evaluateChildNodes(context);
        for (int i = 0; i < childIndexes.length; ++i) {
            for (int j = i + 1; j < childIndexes.length; ++j) {
                GroupByRollupNodeRollupOrCube.validateCompare(childIndexes[i], childIndexes[j]);
            }
        }
        List<int[]> rollup = this.cube ? this.handleCube(childIndexes) : this.handleRollup(childIndexes);
        rollup.add(new int[0]);
        return rollup;
    }

    private static void validateCompare(int[] one, int[] other) throws GroupByRollupDuplicateException {
        if (Arrays.equals(one, other)) {
            throw new GroupByRollupDuplicateException(one);
        }
    }

    private List<int[]> handleCube(int[][] childIndexes) {
        ArrayList<int[]> enumerationSorted = new ArrayList<int[]>();
        int size = this.getChildNodes().size();
        NumberAscCombinationEnumeration e = new NumberAscCombinationEnumeration(size);
        while (e.hasMoreElements()) {
            enumerationSorted.add(e.nextElement());
        }
        Collections.sort(enumerationSorted, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int shared = Math.min(o1.length, o2.length);
                for (int i = 0; i < shared; ++i) {
                    if (o1[i] < o2[i]) {
                        return -1;
                    }
                    if (o1[i] <= o2[i]) continue;
                    return 1;
                }
                if (o1.length > o2.length) {
                    return -1;
                }
                if (o1.length < o2.length) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<int[]> rollup = new ArrayList<int[]>(enumerationSorted.size() + 1);
        LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>();
        for (int[] item : enumerationSorted) {
            keys.clear();
            for (int index : item) {
                int[] childIndex;
                for (int childIndexItem : childIndex = childIndexes[index]) {
                    keys.add(childIndexItem);
                }
            }
            rollup.add(CollectionUtil.intArray(keys));
        }
        return rollup;
    }

    private List<int[]> handleRollup(int[][] childIndexes) {
        int size = this.getChildNodes().size();
        ArrayList<int[]> rollup = new ArrayList<int[]>(size + 1);
        LinkedHashSet<Integer> keyset = new LinkedHashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            keyset.clear();
            for (int j = 0; j < size - i; ++j) {
                int[] childIndex;
                for (int aChildIndex : childIndex = childIndexes[j]) {
                    keyset.add(aChildIndex);
                }
            }
            rollup.add(CollectionUtil.intArray(keyset));
        }
        return rollup;
    }

    private int[][] evaluateChildNodes(GroupByRollupEvalContext context) throws GroupByRollupDuplicateException {
        int size = this.getChildNodes().size();
        int[][] childIndexes = new int[size][];
        for (int i = 0; i < size; ++i) {
            List<int[]> childIndex = this.getChildNodes().get(i).evaluate(context);
            if (childIndex.size() != 1) {
                throw new IllegalStateException();
            }
            childIndexes[i] = childIndex.get(0);
        }
        return childIndexes;
    }
}

